/*
 * Decompiled with CFR 0.152.
 */
package minium.web.config;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class WebDriverProperties {
    private Map<String, Object> desiredCapabilities = Maps.newHashMap();
    private URL url;
    private WindowProperties window;
    private boolean stateful = true;
    private FirefoxProfileProperties firefoxProfile;
    private ChromeOptionsProperties chromeOptions;

    public WebDriverProperties() {
        this.desiredCapabilities.put("browserName", "chrome");
    }

    public Map<String, Object> getDesiredCapabilities() {
        return this.desiredCapabilities;
    }

    public void setDesiredCapabilities(Map<String, Object> capabilities) {
        this.desiredCapabilities = capabilities;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public WindowProperties getWindow() {
        return this.window;
    }

    public void setWindow(WindowProperties window) {
        this.window = window;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public void setStateful(boolean stateful) {
        this.stateful = stateful;
    }

    public FirefoxProfileProperties getFirefoxProfile() {
        return this.firefoxProfile;
    }

    public void setFirefoxProfile(FirefoxProfileProperties firefoxProfile) {
        this.firefoxProfile = firefoxProfile;
    }

    public ChromeOptionsProperties getChromeOptions() {
        return this.chromeOptions;
    }

    public void setChromeOptions(ChromeOptionsProperties chromeOptions) {
        this.chromeOptions = chromeOptions;
    }

    public static class ChromeOptionsProperties {
        private List<String> args;
        private File binary;
        private List<File> extensions;
        private Map<String, Object> preferences;
        private Map<String, Object> loggingPrefs;

        public List<String> getArgs() {
            return this.args;
        }

        public void setArgs(List<String> args) {
            this.args = args;
        }

        public File getBinary() {
            return this.binary;
        }

        public void setBinary(File binary) {
            this.binary = binary;
        }

        public List<File> getExtensions() {
            return this.extensions;
        }

        public void setExtensions(List<File> extensions) {
            this.extensions = extensions;
        }

        public Map<String, Object> getPreferences() {
            return this.preferences;
        }

        public void setPreferences(Map<String, Object> preferences) {
            this.preferences = preferences;
        }

        public Map<String, Object> getLoggingPrefs() {
            return this.loggingPrefs;
        }

        public void setLoggingPrefs(Map<String, Object> loggingPrefs) {
            this.loggingPrefs = loggingPrefs;
        }
    }

    public static class FirefoxProfileProperties {
        private String dir;
        private List<File> extensions;
        private List<PreferenceProperties> preferences;
        private boolean loadNoFocusLib;
        private boolean acceptUntrustedCerts;
        private boolean untrustedCertIssuer;

        public List<File> getExtensions() {
            return this.extensions;
        }

        public void setExtensions(List<File> extensions) {
            this.extensions = extensions;
        }

        public String getDir() {
            return this.dir;
        }

        public void setDir(String profileDir) {
            this.dir = profileDir;
        }

        public List<PreferenceProperties> getPreferences() {
            return this.preferences;
        }

        public void setPreferences(List<PreferenceProperties> preferences) {
            this.preferences = preferences;
        }

        public boolean shouldLoadNoFocusLib() {
            return this.loadNoFocusLib;
        }

        public void setLoadNoFocusLib(boolean loadNoFocusLib) {
            this.loadNoFocusLib = loadNoFocusLib;
        }

        public boolean shouldAcceptUntrustedCerts() {
            return this.acceptUntrustedCerts;
        }

        public void setAcceptUntrustedCerts(boolean acceptUntrustedCerts) {
            this.acceptUntrustedCerts = acceptUntrustedCerts;
        }

        public boolean shouldUntrustedCertIssuer() {
            return this.untrustedCertIssuer;
        }

        public void setUntrustedCertIssuer(boolean untrustedCertIssuer) {
            this.untrustedCertIssuer = untrustedCertIssuer;
        }
    }

    public static class PreferenceProperties {
        private String name;
        private PreferenceType type;
        private Object value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public PreferenceType getType() {
            return this.type;
        }

        public void setType(PreferenceType type) {
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    public static enum PreferenceType {
        BOOLEAN,
        INTEGER,
        STRING;

    }

    public static class WindowProperties {
        private DimensionProperties size;
        private PointProperties position;
        private boolean maximized;

        public DimensionProperties getSize() {
            return this.size;
        }

        public void setSize(DimensionProperties size) {
            this.size = size;
        }

        public PointProperties getPosition() {
            return this.position;
        }

        public void setPosition(PointProperties position) {
            this.position = position;
        }

        public boolean isMaximized() {
            return this.maximized;
        }

        public void setMaximized(boolean maximized) {
            this.maximized = maximized;
        }
    }

    public static class PointProperties {
        private int x;
        private int y;

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PointProperties) {
                PointProperties other = (PointProperties)obj;
                return Objects.equal((Object)this.x, (Object)other.x) && Objects.equal((Object)this.y, (Object)other.y);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.x, this.y});
        }
    }

    public static class DimensionProperties {
        private int width;
        private int height;

        public DimensionProperties() {
        }

        public DimensionProperties(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DimensionProperties) {
                DimensionProperties other = (DimensionProperties)obj;
                return Objects.equal((Object)this.width, (Object)other.width) && Objects.equal((Object)this.height, (Object)other.height);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.width, this.height});
        }
    }
}

