/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.drivers;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;
import minium.web.DocumentWebDriver;
import minium.web.internal.drivers.InternalDocumentWebDriver;
import minium.web.utils.PerformanceUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;

public abstract class BaseDocumentWebDriver
implements InternalDocumentWebDriver {
    protected final WebDriver webDriver;

    public BaseDocumentWebDriver(WebDriver webDriver) {
        Preconditions.checkArgument((webDriver != null && !(webDriver instanceof DocumentWebDriver) ? 1 : 0) != 0);
        this.webDriver = webDriver;
    }

    public void get(String url) {
        this.ensureSwitch();
        this.webDriver.get(url);
    }

    public String getCurrentUrl() {
        this.ensureSwitch();
        return this.webDriver.getCurrentUrl();
    }

    public String getPerformance() {
        this.ensureSwitch();
        return PerformanceUtils.getPerformanceJson(this.webDriver, this.getCurrentUrl());
    }

    public String getTitle() {
        this.ensureSwitch();
        return this.webDriver.getTitle();
    }

    public List<WebElement> findElements(By by) {
        this.ensureSwitch();
        return this.webDriver.findElements(by);
    }

    public WebElement findElement(By by) {
        this.ensureSwitch();
        return this.webDriver.findElement(by);
    }

    public String getPageSource() {
        this.ensureSwitch();
        return this.webDriver.getPageSource();
    }

    public void close() {
        this.ensureSwitch();
        this.webDriver.close();
    }

    public void quit() {
        this.webDriver.quit();
    }

    public Set<String> getWindowHandles() {
        this.ensureSwitch();
        return this.webDriver.getWindowHandles();
    }

    public String getWindowHandle() {
        this.ensureSwitch();
        return this.webDriver.getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        this.ensureSwitch();
        return this.webDriver.switchTo();
    }

    public WebDriver.Navigation navigate() {
        this.ensureSwitch();
        return this.webDriver.navigate();
    }

    public WebDriver.Options manage() {
        this.ensureSwitch();
        return this.webDriver.manage();
    }

    public Object executeScript(String script, Object ... args) {
        this.ensureSwitch();
        return ((JavascriptExecutor)this.webDriver).executeScript(script, args);
    }

    public Object executeAsyncScript(String script, Object ... args) {
        this.ensureSwitch();
        return ((JavascriptExecutor)this.webDriver).executeAsyncScript(script, args);
    }

    public Keyboard getKeyboard() {
        return ((HasInputDevices)this.webDriver).getKeyboard();
    }

    public Mouse getMouse() {
        return ((HasInputDevices)this.webDriver).getMouse();
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        Preconditions.checkState((boolean)(this.webDriver instanceof TakesScreenshot));
        return (X)((TakesScreenshot)this.webDriver).getScreenshotAs(target);
    }

    @Override
    public WebDriver nativeWebDriver() {
        return this.webDriver;
    }

    public int hashCode() {
        return this.webDriver.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == BaseDocumentWebDriver.class && this.equalFields((BaseDocumentWebDriver)obj);
    }

    protected boolean equalFields(BaseDocumentWebDriver obj) {
        return Objects.equal((Object)this.webDriver, (Object)obj.webDriver);
    }
}

