/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import gherkin.formatter.AnsiFormats;
import gherkin.formatter.Format;
import gherkin.formatter.Formats;
import gherkin.formatter.MonochromeFormats;
import gherkin.formatter.model.Result;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

class Stats {
    public static final long ONE_SECOND = 1000000000L;
    public static final long ONE_MINUTE = 60000000000L;
    public static final String PENDING = "pending";
    private SubCounts scenarioSubCounts = new SubCounts();
    private SubCounts stepSubCounts = new SubCounts();
    private long totalDuration = 0L;
    private Formats formats;
    private Locale locale;
    private List<String> failedScenarios = new ArrayList<String>();
    private List<String> pendingScenarios = new ArrayList<String>();
    private List<String> undefinedScenarios = new ArrayList<String>();
    private List<String> passedScenarios = new ArrayList<String>();

    public Stats(boolean monochrome) {
        this(monochrome, Locale.getDefault());
    }

    public Stats(boolean monochrome, Locale locale) {
        this.locale = locale;
        this.formats = monochrome ? new MonochromeFormats() : new AnsiFormats();
    }

    public void printStats(PrintStream out, boolean isStrict) {
        this.printNonZeroResultScenarios(out, isStrict);
        if (this.stepSubCounts.getTotal() == 0) {
            out.println("0 Scenarios");
            out.println("0 Steps");
        } else {
            this.printScenarioCounts(out);
            this.printStepCounts(out);
        }
        this.printDuration(out);
    }

    private void printStepCounts(PrintStream out) {
        out.print(this.stepSubCounts.getTotal());
        out.print(" Steps (");
        this.printSubCounts(out, this.stepSubCounts);
        out.println(")");
    }

    private void printScenarioCounts(PrintStream out) {
        out.print(this.scenarioSubCounts.getTotal());
        out.print(" Scenarios (");
        this.printSubCounts(out, this.scenarioSubCounts);
        out.println(")");
    }

    private void printSubCounts(PrintStream out, SubCounts subCounts) {
        boolean addComma = false;
        addComma = this.printSubCount(out, subCounts.failed, "failed", addComma);
        addComma = this.printSubCount(out, subCounts.skipped, Result.SKIPPED.getStatus(), addComma);
        addComma = this.printSubCount(out, subCounts.pending, PENDING, addComma);
        addComma = this.printSubCount(out, subCounts.undefined, Result.UNDEFINED.getStatus(), addComma);
        addComma = this.printSubCount(out, subCounts.passed, "passed", addComma);
    }

    private boolean printSubCount(PrintStream out, int count, String type, boolean addComma) {
        if (count != 0) {
            if (addComma) {
                out.print(", ");
            }
            Format format = this.formats.get(type);
            out.print(format.text(count + " " + type));
            addComma = true;
        }
        return addComma;
    }

    private void printDuration(PrintStream out) {
        out.print(String.format("%dm", this.totalDuration / 60000000000L));
        DecimalFormat format = new DecimalFormat("0.000", new DecimalFormatSymbols(this.locale));
        out.println(format.format((double)(this.totalDuration % 60000000000L) / 1.0E9) + "s");
    }

    private void printNonZeroResultScenarios(PrintStream out, boolean isStrict) {
        this.printScenarios(out, this.failedScenarios, "failed");
        if (isStrict) {
            this.printScenarios(out, this.pendingScenarios, PENDING);
            this.printScenarios(out, this.undefinedScenarios, Result.UNDEFINED.getStatus());
        }
    }

    private void printScenarios(PrintStream out, List<String> scenarios, String type) {
        Format format = this.formats.get(type);
        if (!scenarios.isEmpty()) {
            out.println(format.text(this.capitalizeFirstLetter(type) + " scenarios:"));
        }
        for (String scenario : scenarios) {
            String[] parts = scenario.split("#");
            out.print(format.text(parts[0]));
            for (int i = 1; i < parts.length; ++i) {
                out.println("#" + parts[i]);
            }
        }
        if (!scenarios.isEmpty()) {
            out.println();
        }
    }

    private String capitalizeFirstLetter(String type) {
        return type.substring(0, 1).toUpperCase(this.locale) + type.substring(1);
    }

    public void addStep(Result result) {
        this.addResultToSubCount(this.stepSubCounts, result.getStatus());
        this.addTime(result.getDuration());
    }

    public void addScenario(String resultStatus) {
        this.addResultToSubCount(this.scenarioSubCounts, resultStatus);
    }

    public void addHookTime(Long duration) {
        this.addTime(duration);
    }

    private void addTime(Long duration) {
        this.totalDuration += duration != null ? duration : 0L;
    }

    private void addResultToSubCount(SubCounts subCounts, String resultStatus) {
        if (resultStatus.equals("failed")) {
            ++subCounts.failed;
        } else if (resultStatus.equals(PENDING)) {
            ++subCounts.pending;
        } else if (resultStatus.equals(Result.UNDEFINED.getStatus())) {
            ++subCounts.undefined;
        } else if (resultStatus.equals(Result.SKIPPED.getStatus())) {
            ++subCounts.skipped;
        } else if (resultStatus.equals("passed")) {
            ++subCounts.passed;
        }
    }

    public void addScenario(String resultStatus, String scenarioDesignation) {
        this.addResultToSubCount(this.scenarioSubCounts, resultStatus);
        if (resultStatus.equals("failed")) {
            this.failedScenarios.add(scenarioDesignation);
        } else if (resultStatus.equals(PENDING)) {
            this.pendingScenarios.add(scenarioDesignation);
        } else if (resultStatus.equals(Result.UNDEFINED.getStatus())) {
            this.undefinedScenarios.add(scenarioDesignation);
        } else if (resultStatus.equals("passed")) {
            this.passedScenarios.add(scenarioDesignation);
        }
    }

    class SubCounts {
        public int passed = 0;
        public int failed = 0;
        public int skipped = 0;
        public int pending = 0;
        public int undefined = 0;

        SubCounts() {
        }

        public int getTotal() {
            return this.passed + this.failed + this.skipped + this.pending + this.undefined;
        }
    }
}

