/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import io.netty.channel.EventLoopGroup;
import org.springframework.context.Lifecycle;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.stomp.ConnectionHandlingStompSession;
import org.springframework.messaging.simp.stomp.Reactor2StompCodec;
import org.springframework.messaging.simp.stomp.StompClientSupport;
import org.springframework.messaging.simp.stomp.StompDecoder;
import org.springframework.messaging.simp.stomp.StompEncoder;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.messaging.tcp.TcpOperations;
import org.springframework.messaging.tcp.reactor.Reactor2TcpClient;
import org.springframework.util.concurrent.ListenableFuture;
import reactor.Environment;
import reactor.io.codec.Codec;
import reactor.io.net.NetStreams;
import reactor.io.net.Spec;
import reactor.io.net.config.ClientSocketOptions;
import reactor.io.net.impl.netty.NettyClientSocketOptions;

public class Reactor2TcpStompClient
extends StompClientSupport
implements Lifecycle {
    private final TcpOperations<byte[]> tcpClient;
    private final EventLoopGroup eventLoopGroup;
    private final Environment environment;
    private volatile boolean running = false;

    public Reactor2TcpStompClient() {
        this("127.0.0.1", 61613);
    }

    public Reactor2TcpStompClient(String host, int port) {
        this.eventLoopGroup = Reactor2TcpClient.initEventLoopGroup();
        this.environment = new Environment();
        this.tcpClient = new Reactor2TcpClient<byte[]>(new StompTcpClientSpecFactory(host, port, this.eventLoopGroup, this.environment));
    }

    public Reactor2TcpStompClient(TcpOperations<byte[]> tcpClient) {
        this.tcpClient = tcpClient;
        this.eventLoopGroup = null;
        this.environment = null;
    }

    public void start() {
        if (!this.isRunning()) {
            this.running = true;
        }
    }

    public void stop() {
        block5: {
            if (this.isRunning()) {
                this.running = false;
                try {
                    if (this.eventLoopGroup != null) {
                        this.eventLoopGroup.shutdownGracefully().await(5000L);
                    }
                    if (this.environment != null) {
                        this.environment.shutdown();
                    }
                }
                catch (InterruptedException ex) {
                    if (!this.logger.isErrorEnabled()) break block5;
                    this.logger.error((Object)"Failed to shutdown gracefully", (Throwable)ex);
                }
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public ListenableFuture<StompSession> connect(StompSessionHandler handler) {
        return this.connect(null, handler);
    }

    public ListenableFuture<StompSession> connect(StompHeaders connectHeaders, StompSessionHandler handler) {
        ConnectionHandlingStompSession session = this.createSession(connectHeaders, handler);
        this.tcpClient.connect(session);
        return session.getSessionFuture();
    }

    public void shutdown() {
        this.tcpClient.shutdown();
    }

    private static class StompTcpClientSpecFactory
    implements NetStreams.TcpClientFactory<Message<byte[]>, Message<byte[]>> {
        private final String host;
        private final int port;
        private final NettyClientSocketOptions socketOptions;
        private final Environment environment;
        private final Reactor2StompCodec codec;

        StompTcpClientSpecFactory(String host, int port, EventLoopGroup group, Environment environment) {
            this.host = host;
            this.port = port;
            this.socketOptions = new NettyClientSocketOptions().eventLoopGroup(group);
            this.environment = environment;
            this.codec = new Reactor2StompCodec(new StompEncoder(), new StompDecoder());
        }

        public Spec.TcpClientSpec<Message<byte[]>, Message<byte[]>> apply(Spec.TcpClientSpec<Message<byte[]>, Message<byte[]>> clientSpec) {
            return ((Spec.TcpClientSpec)((Spec.TcpClientSpec)clientSpec.env(this.environment)).dispatcher(this.environment.getDispatcher("workQueue"))).connect(this.host, this.port).codec((Codec)this.codec).options((ClientSocketOptions)this.socketOptions);
        }
    }
}

