/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.internal;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import cucumber.runtime.Backend;
import cucumber.runtime.Runtime;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.junit.FeatureRunner;
import cucumber.runtime.junit.JUnitOptions;
import cucumber.runtime.junit.JUnitReporter;
import cucumber.runtime.model.CucumberFeature;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import minium.cucumber.MiniumConfiguration;
import minium.cucumber.MiniumCucumber;
import minium.cucumber.config.ConfigProperties;
import minium.cucumber.config.CucumberProperties;
import minium.cucumber.data.MiniumRunTimeOptions;
import minium.cucumber.internal.CucumberContext;
import minium.cucumber.internal.MiniumActiveProfilesResolver;
import minium.cucumber.internal.MiniumBackend;
import minium.cucumber.internal.MiniumRhinoTestContextManager;
import minium.cucumber.internal.RuntimeBuilder;
import minium.script.js.JsBrowserFactory;
import minium.script.js.JsEngine;
import minium.script.js.MiniumJsEngineAdapter;
import minium.script.rhinojs.RhinoEngine;
import minium.web.CoreWebElements;
import minium.web.actions.Browser;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.test.context.ActiveProfiles;

public class MiniumProfileRunner
extends ParentRunner<FeatureRunner>
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MiniumProfileRunner.class);
    @Autowired
    private Environment environment;
    @Autowired
    private CucumberProperties cucumberProperties;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private RhinoEngine rhinoEngine;
    @Autowired
    @Lazy
    private Browser<CoreWebElements.DefaultWebElements> browser;
    @Autowired
    private JsBrowserFactory factory;
    @Autowired
    private ConfigProperties configProperties;
    private List<FeatureRunner> children = Lists.newArrayList();
    private JUnitReporter jUnitReporter;
    private Runtime runtime;
    private List<CucumberFeature> cucumberFeatures;
    private MiniumRhinoTestContextManager testContextManager;
    private Description description;

    public MiniumProfileRunner() throws InitializationError {
        super(MiniumCucumberTest.class);
    }

    public void setTestContextManager(MiniumRhinoTestContextManager testContextManager) {
        this.testContextManager = testContextManager;
    }

    public void afterPropertiesSet() throws Exception {
        ClassLoader classLoader = MiniumCucumberTest.class.getClassLoader();
        new MiniumJsEngineAdapter(this.browser, this.factory).adapt((JsEngine)this.rhinoEngine);
        this.rhinoEngine.putJson("config", this.configProperties.toJson());
        final MiniumRunTimeOptions myruntimeOptions = new MiniumRunTimeOptions(this.cucumberProperties.getOptions().toArgs());
        RhinoEngine rhinoEngine = this.rhinoEngine;
        rhinoEngine.getClass();
        RuntimeBuilder runtimeBuilder = (RuntimeBuilder)this.rhinoEngine.runWithContext((RhinoEngine.RhinoCallable)new RhinoEngine.RhinoCallable<RuntimeBuilder, IOException>(rhinoEngine){

            protected RuntimeBuilder doCall(Context cx, Scriptable scope) throws IOException {
                RuntimeBuilder runtimeBuilder = new RuntimeBuilder();
                runtimeBuilder.withArgs(MiniumProfileRunner.this.cucumberProperties.getOptions().toArgs()).withClassLoader(Thread.currentThread().getContextClassLoader()).withResourceLoader(MiniumProfileRunner.this.resourceLoader).withBackends(MiniumProfileRunner.this.allBackends()).withRuntimeOptions(myruntimeOptions).build();
                return runtimeBuilder;
            }
        });
        this.runtime = runtimeBuilder.getRuntime();
        MiniumRunTimeOptions runtimeOptions = (MiniumRunTimeOptions)runtimeBuilder.getRuntimeOptions();
        this.cucumberFeatures = runtimeOptions.cucumberFeatures(this.resourceLoader);
        CucumberContext.setFeatures(this.cucumberFeatures);
        this.jUnitReporter = new JUnitReporter(runtimeOptions.reporter(classLoader), runtimeOptions.formatter(classLoader), runtimeOptions.isStrict(), new JUnitOptions(runtimeOptions.getJunitOptions()));
        this.addChildren(this.cucumberFeatures);
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = Description.createSuiteDescription((String)this.getName(), (Annotation[])new Annotation[0]);
            for (FeatureRunner child : this.getChildren()) {
                this.description.addChild(this.describeChild(child));
            }
        }
        return this.description;
    }

    public void run(final RunNotifier notifier) {
        try {
            RhinoEngine rhinoEngine = this.rhinoEngine;
            rhinoEngine.getClass();
            this.rhinoEngine.runWithContext((RhinoEngine.RhinoCallable)new RhinoEngine.RhinoCallable<Void, RuntimeException>(rhinoEngine){

                protected Void doCall(Context cx, Scriptable scope) {
                    MiniumProfileRunner.this.doRun(notifier);
                    return null;
                }
            });
            this.jUnitReporter.done();
            this.jUnitReporter.close();
            this.runtime.printSummary();
        }
        finally {
            try {
                CucumberContext.clear();
                if (this.testContextManager != null) {
                    this.testContextManager.destroy();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed destroying TestContentManager for profiles {}", (Object)this.environment.getActiveProfiles(), (Object)e);
            }
        }
    }

    protected String getName() {
        return String.format("%s [%s]", MiniumCucumber.class.getName(), Joiner.on((String)", ").join((Object[])this.environment.getActiveProfiles()));
    }

    protected List<Backend> allBackends() throws IOException {
        ArrayList remoteBackends = Lists.newArrayList();
        for (CucumberProperties.RemoteBackendProperties remoteBackendProperties : this.cucumberProperties.getRemoteBackends()) {
            remoteBackends.add(remoteBackendProperties.createRemoteBackend());
        }
        Backend miniumBackend = (Backend)this.rhinoEngine.runWithContext((RhinoEngine.RhinoCallable)new RhinoEngine.RhinoCallable<Backend, IOException>(this.rhinoEngine){

            protected Backend doCall(Context cx, Scriptable scope) throws IOException {
                return new MiniumBackend(MiniumProfileRunner.this.resourceLoader, cx, scope);
            }
        });
        return ImmutableList.builder().add((Object)miniumBackend).addAll((Iterable)remoteBackends).build();
    }

    protected List<FeatureRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(FeatureRunner child) {
        return child.getDescription();
    }

    protected void runChild(FeatureRunner child, RunNotifier notifier) {
        child.run(notifier);
    }

    private void doRun(RunNotifier notifier) {
        super.run(notifier);
    }

    private void addChildren(List<CucumberFeature> cucumberFeatures) throws InitializationError {
        for (CucumberFeature cucumberFeature : cucumberFeatures) {
            this.children.add(new FeatureRunner(cucumberFeature, this.runtime, this.jUnitReporter));
        }
    }

    @SpringBootTest(classes={MiniumConfiguration.class})
    @ActiveProfiles(resolver=MiniumActiveProfilesResolver.class)
    public static class MiniumCucumberTest {
    }
}

