/*
 * Decompiled with CFR 0.152.
 */
package minium.web.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;

public class PerformanceUtils {
    public static String getPerformanceJson(WebDriver webdriver, String url) {
        ObjectMapper mapper = new ObjectMapper();
        Map performance = (Map)((JavascriptExecutor)webdriver).executeScript("return window.performance", new Object[0]);
        String performanceJson = null;
        List jsErrors = webdriver.manage().logs().get("browser").filter(Level.SEVERE);
        String jsErrorsJson = null;
        Map stats = (Map)((JavascriptExecutor)webdriver).executeScript("var numberOfRequests = 0;var pageSize = 0; performance.getEntriesByType('resource').forEach((r) => { numberOfRequests++; pageSize += r.transferSize }); return {pageSize, numberOfRequests}", new Object[0]);
        String statsJson = null;
        try {
            performanceJson = mapper.writeValueAsString((Object)performance);
            jsErrorsJson = mapper.writeValueAsString((Object)jsErrors);
            statsJson = mapper.writeValueAsString((Object)stats);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        int statusCode = -1;
        Pattern methodPattern = Pattern.compile("Network.responseReceived");
        Pattern urlPattern = Pattern.compile("\"url\":\"" + url + "/?\"");
        Pattern statusPattern = Pattern.compile("\"status\":(\\d+)");
        try {
            LogEntries logEntries = webdriver.manage().logs().get("performance");
            for (LogEntry logEntry : logEntries) {
                Matcher statusMatcher;
                Matcher methodMatcher = methodPattern.matcher(logEntry.getMessage());
                Matcher urlMatcher = urlPattern.matcher(logEntry.getMessage());
                if (!methodMatcher.find() || !urlMatcher.find() || !(statusMatcher = statusPattern.matcher(logEntry.getMessage())).find()) continue;
                statusCode = Integer.parseInt(statusMatcher.group(1));
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (statusCode == -1) {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            try {
                HttpResponse response = client.execute((HttpUriRequest)new HttpGet(url));
                statusCode = response.getStatusLine().getStatusCode();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "{ \"url\": \"" + url + "\", \"data\": " + performanceJson + ", \"stats\": " + statsJson + ", \"statusCode\": " + statusCode + ", \"jsErrors\": " + jsErrorsJson + " }";
    }
}

