/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.report.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonView;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import minium.cucumber.report.domain.DocString;
import minium.cucumber.report.domain.Embedding;
import minium.cucumber.report.domain.Match;
import minium.cucumber.report.domain.Result;
import minium.cucumber.report.domain.Row;
import minium.cucumber.report.domain.Status;
import minium.cucumber.report.domain.Views;

@JsonPropertyOrder(value={"name", "keyword", "line", "result", "results", "embeddings", "match", "matchedColumns", "rows"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Step {
    @JsonView(value={Views.Public.class})
    private String name;
    @JsonView(value={Views.Public.class})
    private String keyword;
    @JsonView(value={Views.Public.class})
    private Integer line;
    @JsonView(value={Views.Public.class})
    private Result result;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonView(value={Views.Public.class})
    private Map<String, Result> results = Maps.newHashMap();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonView(value={Views.Public.class})
    private List<Row> rows = Lists.newArrayList();
    @JsonView(value={Views.Public.class})
    private Match match;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonView(value={Views.Public.class})
    private List<Integer> matchedColumns = Lists.newArrayList();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonView(value={Views.Public.class})
    private List<Embedding> embeddings = Lists.newArrayList();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonView(value={Views.Public.class})
    private List<String> output = Lists.newArrayList();
    @JsonView(value={Views.Public.class})
    private DocString docString;
    @JsonView(value={Views.Public.class})
    private String errorMessage;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keyword == null ? 0 : this.keyword.hashCode());
        result = 31 * result + (this.line == null ? 0 : this.line.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Step other = (Step)obj;
        if (this.keyword == null ? other.keyword != null : !this.keyword.equals(other.keyword)) {
            return false;
        }
        if (this.line == null ? other.line != null : !this.line.equals(other.line)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String getKeyword() {
        return this.keyword;
    }

    public DocString getDocString() {
        return this.docString;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public List<String> getOutput() {
        return this.output;
    }

    public Match getMatch() {
        return this.match;
    }

    public List<Embedding> getEmbeddings() {
        return this.embeddings;
    }

    public Status getStatus() {
        return this.result == null ? Status.MISSING : this.result.getStatus();
    }

    public Long getDuration() {
        if (this.result == null) {
            return 1L;
        }
        return this.result.getDuration();
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Integer getLine() {
        return this.line;
    }

    public void setLine(Integer line) {
        this.line = line;
    }

    public void combineStep(String profile, Step step) {
        this.results.put(profile, step.getResult());
        if (this.result != null) {
            this.result = null;
        }
    }
}

