/*
 * Decompiled with CFR 0.152.
 */
package minium.script.rhinojs;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import minium.Elements;
import minium.internal.Paths;
import minium.internal.Throwables;
import minium.script.js.JsEngine;
import minium.script.rhinojs.RhinoProperties;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.json.JsonParser;
import org.mozilla.javascript.tools.shell.Global;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class RhinoEngine
implements JsEngine,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(RhinoEngine.class);
    private static final ThreadFactory FACTORY = new ThreadFactoryBuilder().setNameFormat("jsengine-thread-%d").setDaemon(true).build();
    private WrapFactory wrapFactory = new WrapFactory(){

        public Object wrap(Context cx, Scriptable scope, Object obj, Class<?> staticType) {
            Scriptable sret;
            Object ret = super.wrap(cx, scope, obj, staticType);
            if (ret instanceof Scriptable && (sret = (Scriptable)ret).getPrototype() == null) {
                if (obj instanceof Elements) {
                    sret.setPrototype(RhinoEngine.this.prototype);
                } else {
                    sret.setPrototype((Scriptable)new NativeObject());
                }
            }
            return ret;
        }
    };
    private Thread executionThread;
    private ExecutorService executorService;
    private Future<?> lastTask;
    private Scriptable scope;
    private Scriptable prototype;
    private URLClassLoader classloader;

    public <T> RhinoEngine(final RhinoProperties rhinoProperties) {
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Preconditions.checkState((RhinoEngine.this.executionThread == null ? 1 : 0) != 0, (Object)"Only one thread is supported");
                RhinoEngine.this.executionThread = FACTORY.newThread(r);
                URL[] additionalClasspath = (URL[])rhinoProperties.getAdditionalClasspath().stream().toArray(URL[]::new);
                RhinoEngine.this.classloader = new URLClassLoader(additionalClasspath, RhinoEngine.this.executionThread.getContextClassLoader());
                RhinoEngine.this.executionThread.setContextClassLoader(RhinoEngine.this.classloader);
                return RhinoEngine.this.executionThread;
            }
        });
        this.runWithContext(new RhinoCallable<Void, RuntimeException>(){

            @Override
            protected Void doCall(Context cx, Scriptable s) {
                try {
                    Global global = new Global(cx);
                    RhinoProperties.RequireProperties require = rhinoProperties.getRequire();
                    if (require != null) {
                        List<String> modulePathURIs = RhinoEngine.this.getModulePathURIs(require);
                        LOGGER.debug("Module paths: {}", modulePathURIs);
                        global.installRequire(cx, modulePathURIs, require.isSandboxed());
                    }
                    try (InputStreamReader in = new InputStreamReader(RhinoEngine.this.classloader.getResourceAsStream("compat/timeout.js"));){
                        cx.evaluateReader((Scriptable)global, (Reader)in, "compat/timeout.js", 1, null);
                    }
                    RhinoEngine.this.scope = (Scriptable)global;
                    RhinoEngine.this.prototype = (Scriptable)new NativeObject();
                    RhinoEngine.this.scope.put("__prototype", RhinoEngine.this.scope, (Object)RhinoEngine.this.prototype);
                    return null;
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
    }

    public <T> T runScript(File sourceFile) throws IOException {
        try (FileReader reader = new FileReader(sourceFile);){
            T t = this.runScript(reader, sourceFile.getPath());
            return t;
        }
    }

    public <T> T runScript(String path) throws IOException {
        List urls = Paths.toURLs((String)path);
        T result = null;
        for (URL url : urls) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            Throwable throwable = null;
            try {
                result = this.runScript(reader, url.getPath());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((Reader)reader).close();
            }
        }
        return result;
    }

    public <T> T runScript(final Reader reader, final String sourceName) throws IOException {
        return this.runWithContext(new RhinoCallable<T, IOException>(){

            @Override
            protected T doCall(Context cx, Scriptable scope) throws IOException {
                Object val = cx.evaluateReader(scope, reader, sourceName, 1, null);
                val = RhinoEngine.this.unwrappedValue(val);
                return val;
            }
        });
    }

    public <T> T eval(String expression, int line) {
        return this.eval(expression, "<expression>", line);
    }

    public <T> T eval(final String expression, final String filePath, final int line) {
        return this.runWithContext(new RhinoCallable<T, RuntimeException>(){

            @Override
            protected T doCall(Context cx, Scriptable scope) {
                Object val = cx.evaluateString(scope, expression, filePath, line, null);
                val = RhinoEngine.this.unwrappedValue(val);
                return val;
            }
        });
    }

    public boolean contains(final String varName) {
        return this.runWithContext(new RhinoCallable<Boolean, RuntimeException>(){

            @Override
            protected Boolean doCall(Context cx, Scriptable scope) {
                return scope.get(varName, scope) != null;
            }
        });
    }

    public Object get(final String varName) {
        return this.runWithContext(new RhinoCallable<Object, RuntimeException>(){

            @Override
            protected Object doCall(Context cx, Scriptable scope) {
                return RhinoEngine.this.unwrappedValue(scope.get(varName, scope));
            }
        });
    }

    public <T> T get(String varName, Class<T> clazz) {
        return (T)this.get(varName);
    }

    public void put(final String varName, final Object object) {
        this.runWithContext(new RhinoCallable<Void, RuntimeException>(){

            @Override
            protected Void doCall(Context cx, Scriptable scope) {
                scope.put(varName, scope, object != null ? Context.javaToJS((Object)object, (Scriptable)scope) : null);
                return null;
            }
        });
    }

    public void delete(final String varName) {
        this.runWithContext(new RhinoCallable<Void, RuntimeException>(){

            @Override
            protected Void doCall(Context cx, Scriptable scope) {
                scope.delete(varName);
                return null;
            }
        });
    }

    public void putJson(final String varName, final String json) {
        this.runWithContext(new RhinoCallable<Object, RuntimeException>(){

            @Override
            protected Object doCall(Context cx, Scriptable scope) throws RuntimeException {
                try {
                    Object obj = new JsonParser(cx, scope).parseValue(json);
                    scope.put(varName, scope, obj);
                    return null;
                }
                catch (JsonParser.ParseException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
    }

    public boolean isRunning() {
        return this.lastTask != null && !this.lastTask.isDone();
    }

    public void cancel() {
        if (this.lastTask != null) {
            this.lastTask.cancel(true);
        }
    }

    public StackTraceElement[] getExecutionStackTrace() {
        if (this.lastTask != null && !this.lastTask.isDone()) {
            return this.filterStackTrace(this.executionThread.getStackTrace());
        }
        return new StackTraceElement[0];
    }

    public String toString(final Object obj) {
        return this.runWithContext(new RhinoCallable<String, RuntimeException>(){

            @Override
            protected String doCall(Context cx, Scriptable scope) throws RuntimeException {
                if (obj == null) {
                    return "null";
                }
                if (obj instanceof Wrapper) {
                    Object unwrapped = ((Wrapper)obj).unwrap();
                    return unwrapped.toString();
                }
                if (obj instanceof Scriptable) {
                    return (String)cx.evaluateString((Scriptable)obj, "(function(obj) {   try {     var str = JSON.stringify(obj);     if (typeof str === 'string') return str;   } catch (e) { }   return obj.toString(); })(this)", "<toString>", 1, null);
                }
                if (obj instanceof Undefined) {
                    return "undefined";
                }
                return obj.toString();
            }
        });
    }

    public void destroy() throws Exception {
        this.executorService.shutdown();
        this.classloader.close();
    }

    public <T, X extends Exception> T runWithContext(RhinoCallable<? extends T, X> fn) throws X {
        if (Thread.currentThread() == this.executionThread) {
            Context currentContext = Context.getCurrentContext();
            Preconditions.checkState((currentContext != null ? 1 : 0) != 0, (Object)"A rhino context was expected at this thread");
            return fn.doCall(currentContext, this.scope);
        }
        Preconditions.checkState((this.lastTask == null || this.lastTask.isDone() ? 1 : 0) != 0);
        try {
            this.lastTask = this.executorService.submit(fn);
            return (T)this.lastTask.get();
        }
        catch (InterruptedException e) {
            this.lastTask.cancel(true);
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Throwables.propagateIfPossible((Throwable)cause);
            throw (Exception)cause;
        }
    }

    protected StackTraceElement[] filterStackTrace(StackTraceElement[] stackTrace) {
        ArrayList processed = Lists.newArrayList();
        for (StackTraceElement element : stackTrace) {
            if (!element.getClassName().startsWith("org.mozilla.javascript.gen") || element.getLineNumber() == -1) continue;
            String fileName = null;
            File file = new File(element.getFileName());
            if (file.exists() && file.isFile()) {
                fileName = file.getAbsolutePath();
            }
            if (fileName == null) {
                fileName = element.getFileName();
            }
            processed.add(new StackTraceElement(element.getFileName(), element.getMethodName(), fileName, element.getLineNumber()));
        }
        return processed.toArray(new StackTraceElement[processed.size()]);
    }

    protected Object unwrappedValue(Object val) {
        if (val != null && val instanceof Wrapper) {
            val = ((Wrapper)val).unwrap();
        }
        return val;
    }

    protected List<String> getModulePathURIs(RhinoProperties.RequireProperties properties) {
        ArrayList uris = Lists.newArrayList();
        for (String modulePath : properties.getModulePaths()) {
            try {
                List urls = Paths.toURLs((String)modulePath);
                for (URL url : urls) {
                    uris.add(url.toString());
                }
            }
            catch (Exception e) {
                uris.add(new File(modulePath).toURI().toString());
            }
        }
        return uris;
    }

    public abstract class RhinoCallable<T, X extends Exception>
    implements Callable<T> {
        @Override
        public T call() throws X {
            Context cx = Context.enter();
            cx.setWrapFactory(RhinoEngine.this.wrapFactory);
            try {
                T t = this.doCall(cx, RhinoEngine.this.scope);
                return t;
            }
            finally {
                Context.exit();
            }
        }

        protected abstract T doCall(Context var1, Scriptable var2) throws X;
    }
}

