/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.sl.draw.DrawPaint;
import org.apache.poi.sl.usermodel.ColorStyle;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.sl.usermodel.PlaceableShape;
import org.apache.poi.sl.usermodel.Shape;
import org.apache.poi.util.Internal;
import org.apache.poi.xslf.model.PropertyFetcher;
import org.apache.poi.xslf.usermodel.Placeholder;
import org.apache.poi.xslf.usermodel.XSLFColor;
import org.apache.poi.xslf.usermodel.XSLFShapeContainer;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientStop;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGroupShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNoFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSchemeColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrix;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrixReference;
import org.openxmlformats.schemas.drawingml.x2006.main.STPathShadeType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTApplicationNonVisualDrawingProps;
import org.openxmlformats.schemas.presentationml.x2006.main.CTBackground;
import org.openxmlformats.schemas.presentationml.x2006.main.CTBackgroundProperties;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;
import org.openxmlformats.schemas.presentationml.x2006.main.STPlaceholderType;

public abstract class XSLFShape
implements Shape<XSLFShape, XSLFTextParagraph> {
    private final XmlObject _shape;
    private final XSLFSheet _sheet;
    private XSLFShapeContainer _parent;
    private CTShapeProperties _spPr;
    private CTShapeStyle _spStyle;
    private CTNonVisualDrawingProps _nvPr;
    private CTPlaceholder _ph;

    protected XSLFShape(XmlObject shape, XSLFSheet sheet) {
        this._shape = shape;
        this._sheet = sheet;
    }

    public final XmlObject getXmlObject() {
        return this._shape;
    }

    public XSLFSheet getSheet() {
        return this._sheet;
    }

    public String getShapeName() {
        return this.getCNvPr().getName();
    }

    public int getShapeId() {
        return (int)this.getCNvPr().getId();
    }

    @Internal
    void copy(XSLFShape sh) {
        if (!this.getClass().isInstance(sh)) {
            throw new IllegalArgumentException("Can't copy " + sh.getClass().getSimpleName() + " into " + this.getClass().getSimpleName());
        }
        if (this instanceof PlaceableShape) {
            PlaceableShape ps = (PlaceableShape)this;
            ps.setAnchor(((PlaceableShape)sh).getAnchor());
        }
    }

    public void setParent(XSLFShapeContainer parent) {
        this._parent = parent;
    }

    public XSLFShapeContainer getParent() {
        return this._parent;
    }

    protected PaintStyle getFillPaint() {
        CTShapeStyle style;
        PropertyFetcher<PaintStyle> fetcher = new PropertyFetcher<PaintStyle>(){

            @Override
            public boolean fetch(XSLFShape shape) {
                CTShapeProperties pr = null;
                try {
                    pr = shape.getSpPr();
                    if (pr.isSetNoFill()) {
                        this.setValue(null);
                        return true;
                    }
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
                if (pr == null) {
                    pr = shape.getBgPr();
                }
                if (pr == null) {
                    pr = shape.getGrpSpPr();
                }
                if (pr == null && shape.getXmlObject() instanceof CTBackground) {
                    pr = shape.getXmlObject();
                }
                if (pr == null) {
                    return false;
                }
                PaintStyle paint = null;
                PackagePart pp = XSLFShape.this.getSheet().getPackagePart();
                for (XmlObject obj : pr.selectPath("*")) {
                    paint = XSLFShape.this.selectPaint(obj, null, pp);
                    if (paint == null) continue;
                    this.setValue(paint);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        PaintStyle paint = (PaintStyle)fetcher.getValue();
        if (paint != null) {
            return paint;
        }
        CTStyleMatrixReference fillRef = null;
        if (fillRef == null && (style = this.getSpStyle()) != null) {
            fillRef = style.getFillRef();
        }
        if (fillRef == null) {
            fillRef = this.getBgRef();
        }
        paint = this.selectPaint(fillRef);
        return paint;
    }

    protected CTBackgroundProperties getBgPr() {
        String xquery = "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' p:bgPr";
        return this.selectProperty(CTBackgroundProperties.class, xquery);
    }

    protected CTStyleMatrixReference getBgRef() {
        String xquery = "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' p:bgRef";
        return this.selectProperty(CTStyleMatrixReference.class, xquery);
    }

    protected CTGroupShapeProperties getGrpSpPr() {
        String xquery = "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' p:grpSpPr";
        return this.selectProperty(CTGroupShapeProperties.class, xquery);
    }

    protected CTNonVisualDrawingProps getCNvPr() {
        if (this._nvPr == null) {
            String xquery = "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:cNvPr";
            this._nvPr = this.selectProperty(CTNonVisualDrawingProps.class, xquery);
        }
        return this._nvPr;
    }

    protected CTShapeProperties getSpPr() {
        if (this._spPr == null) {
            String xquery = "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' p:spPr";
            this._spPr = this.selectProperty(CTShapeProperties.class, xquery);
        }
        if (this._spPr == null) {
            throw new IllegalStateException("CTShapeProperties was not found.");
        }
        return this._spPr;
    }

    protected CTShapeStyle getSpStyle() {
        if (this._spStyle == null) {
            String xquery = "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' p:style";
            this._spStyle = this.selectProperty(CTShapeStyle.class, xquery);
        }
        return this._spStyle;
    }

    protected CTPlaceholder getCTPlaceholder() {
        if (this._ph == null) {
            String xquery = "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:nvPr/p:ph";
            this._ph = this.selectProperty(CTPlaceholder.class, xquery);
        }
        return this._ph;
    }

    protected void setPlaceholder(Placeholder placeholder) {
        String xquery = "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:nvPr";
        CTApplicationNonVisualDrawingProps nv = this.selectProperty(CTApplicationNonVisualDrawingProps.class, xquery);
        if (nv == null) {
            return;
        }
        if (placeholder == null) {
            if (nv.isSetPh()) {
                nv.unsetPh();
            }
            this._ph = null;
        } else {
            nv.addNewPh().setType(STPlaceholderType.Enum.forInt((int)(placeholder.ordinal() + 1)));
        }
    }

    protected <T extends XmlObject> T selectProperty(Class<T> resultClass, String xquery) {
        XmlObject[] rs = this.getXmlObject().selectPath(xquery);
        if (rs.length == 0) {
            return null;
        }
        return (T)(resultClass.isInstance(rs[0]) ? rs[0] : null);
    }

    protected boolean fetchShapeProperty(PropertyFetcher<?> visitor) {
        boolean ok = visitor.fetch(this);
        XSLFSheet masterSheet = (XSLFSheet)this.getSheet().getMasterSheet();
        CTPlaceholder ph = this.getCTPlaceholder();
        if (masterSheet != null && ph != null) {
            XSLFSimpleShape masterShape;
            if (!ok && (masterShape = masterSheet.getPlaceholder(ph)) != null) {
                ok = visitor.fetch(masterShape);
            }
            if (!ok) {
                int textType;
                if (!ph.isSetType()) {
                    textType = 2;
                } else {
                    switch (ph.getType().intValue()) {
                        case 1: 
                        case 3: {
                            textType = 1;
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 7: {
                            textType = ph.getType().intValue();
                            break;
                        }
                        default: {
                            textType = 2;
                        }
                    }
                }
                XSLFSheet master = (XSLFSheet)masterSheet.getMasterSheet();
                if (master != null && (masterShape = master.getPlaceholderByType(textType)) != null) {
                    ok = visitor.fetch(masterShape);
                }
            }
        }
        return ok;
    }

    protected PaintStyle getPaint(XmlObject spPr, CTSchemeColor phClr) {
        XmlObject obj;
        PaintStyle paint = null;
        PackagePart pp = this.getSheet().getPackagePart();
        XmlObject[] arr$ = spPr.selectPath("*");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (paint = this.selectPaint(obj = arr$[i$], phClr, pp)) == null; ++i$) {
        }
        return paint;
    }

    protected PaintStyle selectPaint(XmlObject obj, CTSchemeColor phClr, PackagePart parentPart) {
        if (obj instanceof CTNoFillProperties) {
            return null;
        }
        if (obj instanceof CTSolidColorFillProperties) {
            return this.selectPaint((CTSolidColorFillProperties)obj, phClr);
        }
        if (obj instanceof CTBlipFillProperties) {
            return this.selectPaint((CTBlipFillProperties)obj, parentPart);
        }
        if (obj instanceof CTGradientFillProperties) {
            return this.selectPaint((CTGradientFillProperties)obj, phClr);
        }
        if (obj instanceof CTStyleMatrixReference) {
            return this.selectPaint((CTStyleMatrixReference)obj);
        }
        return null;
    }

    protected PaintStyle selectPaint(CTSolidColorFillProperties solidFill, CTSchemeColor phClr) {
        XSLFTheme theme = this.getSheet().getTheme();
        if (phClr == null && solidFill.isSetSchemeClr()) {
            phClr = solidFill.getSchemeClr();
        }
        XSLFColor c = new XSLFColor((XmlObject)solidFill, theme, phClr);
        return DrawPaint.createSolidPaint((ColorStyle)c.getColorStyle());
    }

    protected PaintStyle selectPaint(CTBlipFillProperties blipFill, final PackagePart parentPart) {
        final CTBlip blip = blipFill.getBlip();
        return new PaintStyle.TexturePaint(){

            private PackagePart getPart() {
                try {
                    String blipId = blip.getEmbed();
                    PackageRelationship rel = parentPart.getRelationship(blipId);
                    return parentPart.getRelatedPart(rel);
                }
                catch (InvalidFormatException e) {
                    throw new RuntimeException(e);
                }
            }

            public InputStream getImageData() {
                try {
                    return this.getPart().getInputStream();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public String getContentType() {
                return this.getPart().getContentType();
            }

            public int getAlpha() {
                return blip.sizeOfAlphaModFixArray() > 0 ? blip.getAlphaModFixArray(0).getAmt() : 100000;
            }
        };
    }

    protected PaintStyle selectPaint(final CTGradientFillProperties gradFill, CTSchemeColor phClr) {
        CTGradientStop[] gs = gradFill.getGsLst().getGsArray();
        Arrays.sort(gs, new Comparator<CTGradientStop>(){

            @Override
            public int compare(CTGradientStop o1, CTGradientStop o2) {
                Integer pos1 = o1.getPos();
                Integer pos2 = o2.getPos();
                return pos1.compareTo(pos2);
            }
        });
        final ColorStyle[] cs = new ColorStyle[gs.length];
        final float[] fractions = new float[gs.length];
        XSLFTheme theme = this.getSheet().getTheme();
        int i = 0;
        for (CTGradientStop cgs : gs) {
            CTSchemeColor phClrCgs = phClr;
            if (phClrCgs == null && cgs.isSetSchemeClr()) {
                phClrCgs = cgs.getSchemeClr();
            }
            cs[i] = new XSLFColor((XmlObject)cgs, theme, phClrCgs).getColorStyle();
            fractions[i] = (float)cgs.getPos() / 100000.0f;
            ++i;
        }
        return new PaintStyle.GradientPaint(){

            public double getGradientAngle() {
                return gradFill.isSetLin() ? (double)gradFill.getLin().getAng() / 60000.0 : 0.0;
            }

            public ColorStyle[] getGradientColors() {
                return cs;
            }

            public float[] getGradientFractions() {
                return fractions;
            }

            public boolean isRotatedWithShape() {
                return gradFill.isSetRotWithShape() || !gradFill.getRotWithShape();
            }

            public PaintStyle.GradientPaint.GradientType getGradientType() {
                if (gradFill.isSetLin()) {
                    return PaintStyle.GradientPaint.GradientType.linear;
                }
                if (gradFill.isSetPath()) {
                    STPathShadeType.Enum ps = gradFill.getPath().getPath();
                    if (ps == STPathShadeType.CIRCLE) {
                        return PaintStyle.GradientPaint.GradientType.circular;
                    }
                    if (ps == STPathShadeType.SHAPE) {
                        return PaintStyle.GradientPaint.GradientType.shape;
                    }
                }
                return PaintStyle.GradientPaint.GradientType.linear;
            }
        };
    }

    protected PaintStyle selectPaint(CTStyleMatrixReference fillRef) {
        if (fillRef == null) {
            return null;
        }
        int idx = (int)fillRef.getIdx();
        CTSchemeColor phClr = fillRef.getSchemeClr();
        XSLFSheet sheet = this.getSheet();
        XSLFTheme theme = sheet.getTheme();
        XmlObject fillProps = null;
        CTStyleMatrix matrix = theme.getXmlObject().getThemeElements().getFmtScheme();
        if (idx >= 1 && idx <= 999) {
            fillProps = matrix.getFillStyleLst().selectPath("*")[idx - 1];
        } else if (idx >= 1001) {
            fillProps = matrix.getBgFillStyleLst().selectPath("*")[idx - 1001];
        }
        return fillProps == null ? null : this.selectPaint(fillProps, phClr, theme.getPackagePart());
    }
}

