/*
 * Decompiled with CFR 0.152.
 */
package platypus;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import platypus.InstanceProvider;
import platypus.internal.Casts;

public class InstanceProviders {
    public static <T> InstanceProvider<T> ofInstance(T instance) {
        return new IdentityInstanceProvider<T>(instance);
    }

    public static <T> InstanceProvider<T> adapt(InvocationHandler handler, Collection<Class<?>> intfs) {
        Class classClazz = (Class)Casts.unsafeCast(Class.class);
        return new InvocationHandlerInstanceProviderAdapter(handler, (Class[])Iterables.toArray(intfs, (Class)classClazz));
    }

    public static <T> InstanceProvider<T> adapt(InvocationHandler handler, Class<?> ... intfs) {
        return new InvocationHandlerInstanceProviderAdapter(handler, (Class[])intfs);
    }

    public static <T> InstanceProvider<T> memoize(InstanceProvider<T> provider) {
        return new MemoizingInstanceProvider<T>(provider);
    }

    private static final class InvocationHandlerInstanceProviderAdapter<T>
    implements InstanceProvider<T> {
        private final InvocationHandler handler;
        private final Class<?>[] intfs;

        private InvocationHandlerInstanceProviderAdapter(InvocationHandler handler, Class<?> ... intfs) {
            this.handler = handler;
            this.intfs = intfs;
        }

        @Override
        public T provide() {
            return (T)Proxy.newProxyInstance(this.handler.getClass().getClassLoader(), this.intfs, this.handler);
        }
    }

    private static class MemoizingInstanceProvider<T>
    implements InstanceProvider<T> {
        private final InstanceProvider<T> delegate;
        private boolean initialized = false;
        private T value;

        public MemoizingInstanceProvider(InstanceProvider<T> delegate) {
            this.delegate = (InstanceProvider)Preconditions.checkNotNull(delegate);
        }

        @Override
        public T provide() {
            if (!this.initialized) {
                this.value = this.delegate.provide();
                this.initialized = true;
            }
            return this.value;
        }
    }

    private static class IdentityInstanceProvider<T>
    implements InstanceProvider<T> {
        private final T obj;

        public IdentityInstanceProvider(T obj) {
            this.obj = Preconditions.checkNotNull(obj);
        }

        @Override
        public T provide() {
            return this.obj;
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof IdentityInstanceProvider) {
                return this.obj.equals(((IdentityInstanceProvider)other).obj);
            }
            return false;
        }

        public String toString() {
            return String.format("IdentityInstanceProvider{obj=%s}", this.obj);
        }
    }
}

