/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.rhino;

import cucumber.runtime.Backend;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.rhino.JavaScriptSnippet;
import cucumber.runtime.rhino.RhinoHookDefinition;
import cucumber.runtime.rhino.RhinoStepDefinition;
import cucumber.runtime.snippets.FunctionNameGenerator;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.formatter.model.Step;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.tools.shell.Global;

public class RhinoBackend
implements Backend {
    private static final String JS_DSL = "/cucumber/runtime/rhino/dsl.js";
    private final SnippetGenerator snippetGenerator = new SnippetGenerator((Snippet)new JavaScriptSnippet());
    private final ResourceLoader resourceLoader;
    private final Context cx;
    private final Scriptable scope;
    private List<String> gluePaths;
    private Glue glue;
    private Function buildWorldFn;
    private Function disposeWorldFn;

    public RhinoBackend(ResourceLoader resourceLoader) throws IOException {
        this.resourceLoader = resourceLoader;
        this.cx = Context.enter();
        this.scope = new Global(this.cx);
        this.scope.put("jsBackend", this.scope, (Object)this);
        for (Resource resource : resourceLoader.resources("classpath:cucumber/runtime/rhino", ".js")) {
            this.runScript(resource);
        }
    }

    public void loadGlue(Glue glue, List<String> gluePaths) {
        this.glue = glue;
        this.gluePaths = gluePaths;
        for (String gluePath : gluePaths) {
            for (Resource resource : this.resourceLoader.resources(gluePath, ".js")) {
                this.runScript(resource);
            }
        }
    }

    private void runScript(Resource resource) {
        try {
            this.cx.evaluateReader(this.scope, (Reader)new InputStreamReader(resource.getInputStream(), "UTF-8"), resource.getAbsolutePath(), 1, null);
        }
        catch (IOException e) {
            throw new CucumberException("Failed to evaluate JavaScript in " + resource.getAbsolutePath(), (Throwable)e);
        }
    }

    public void setUnreportedStepExecutor(UnreportedStepExecutor executor) {
    }

    public void buildWorld() {
        if (this.buildWorldFn != null) {
            this.buildWorldFn.call(this.cx, this.scope, this.scope, new Object[0]);
        }
    }

    public void disposeWorld() {
        try {
            if (this.disposeWorldFn != null) {
                this.disposeWorldFn.call(this.cx, this.scope, this.scope, new Object[0]);
            }
        }
        finally {
            this.buildWorldFn = null;
            this.disposeWorldFn = null;
        }
    }

    public void registerWorld(Function buildWorldFn, Function disposeWorldFn) {
        if (this.buildWorldFn != null) {
            throw new CucumberException("World is already set");
        }
        if (buildWorldFn == null) {
            throw new CucumberException("World requires at least a build function");
        }
        this.buildWorldFn = buildWorldFn;
        this.disposeWorldFn = disposeWorldFn;
    }

    public String getSnippet(Step step, FunctionNameGenerator functionNameGenerator) {
        return this.snippetGenerator.getSnippet(step, functionNameGenerator);
    }

    private StackTraceElement jsLocation() {
        StackTraceElement[] stackTraceElements;
        Throwable t = new Throwable();
        for (StackTraceElement stackTraceElement : stackTraceElements = t.getStackTrace()) {
            boolean hasLine;
            boolean js = stackTraceElement.getFileName().endsWith(".js");
            if (!js) continue;
            boolean isDsl = stackTraceElement.getFileName().endsWith(JS_DSL);
            boolean bl = hasLine = stackTraceElement.getLineNumber() != -1;
            if (isDsl || !hasLine) continue;
            return stackTraceElement;
        }
        throw new RuntimeException("Couldn't find location for step definition");
    }

    public void addStepDefinition(Global jsStepDefinition, NativeRegExp regexp, NativeFunction bodyFunc, NativeFunction argumentsFromFunc) throws Throwable {
        StackTraceElement stepDefLocation = this.jsLocation();
        RhinoStepDefinition stepDefinition = new RhinoStepDefinition(this.cx, this.scope, jsStepDefinition, regexp, bodyFunc, stepDefLocation, argumentsFromFunc);
        this.glue.addStepDefinition((StepDefinition)stepDefinition);
    }

    public void addBeforeHook(Function fn, String[] tags, int order, long timeoutMillis) {
        StackTraceElement stepDefLocation = this.jsLocation();
        RhinoHookDefinition hookDefinition = new RhinoHookDefinition(this.cx, this.scope, fn, tags, order, timeoutMillis, stepDefLocation);
        this.glue.addBeforeHook((HookDefinition)hookDefinition);
    }

    public void addAfterHook(Function fn, String[] tags, int order, long timeoutMillis) {
        StackTraceElement stepDefLocation = this.jsLocation();
        RhinoHookDefinition hookDefinition = new RhinoHookDefinition(this.cx, this.scope, fn, tags, order, timeoutMillis, stepDefLocation);
        this.glue.addAfterHook((HookDefinition)hookDefinition);
    }
}

