/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.reflect.TypeToken;
import minium.Elements;
import minium.internal.BaseElements;
import minium.web.BasicWebElements;
import minium.web.DocumentWebDriver;
import minium.web.TargetLocatorWebElements;
import minium.web.WebElements;
import minium.web.internal.BaseDocumentRoots;
import minium.web.internal.InternalWebElements;
import minium.web.internal.drivers.DocumentWebElement;
import minium.web.internal.drivers.FrameWebDriver;
import minium.web.internal.drivers.WindowWebDriver;

public class DefaultTargetLocatorWebElements<T extends BasicWebElements<T>>
extends BaseElements<T>
implements TargetLocatorWebElements<T> {
    private static final String FRAMES_CSS_SELECTOR = "iframe, frame";
    private TypeToken<BasicWebElements<T>> basicWebElementsTypeToken = new TypeToken<BasicWebElements<T>>(this.getClass()){};

    @Override
    public T frames() {
        BasicWebElements frameElems = (BasicWebElements)((BasicWebElements)((BasicWebElements)((BasicWebElements)this.as(this.basicWebElementsTypeToken)).find(FRAMES_CSS_SELECTOR)).add((WebElements)this.myself())).filter(FRAMES_CSS_SELECTOR);
        return (T)((BasicWebElements)this.internalFactory().createMixin((Elements)this.myself(), new FrameRoots<BasicWebElements>(frameElems)));
    }

    @Override
    public T windows() {
        return (T)((BasicWebElements)this.internalFactory().createMixin((Elements)this.myself(), new WindowRoots()));
    }

    @Override
    public T documentRoots() {
        return (T)((BasicWebElements)((InternalWebElements)this.as(InternalWebElements.class)).documentRoots().as(this.typeVariableToken()));
    }

    public static class WindowRoots<T extends WebElements>
    extends BaseDocumentRoots<T> {
        @Override
        public Iterable<DocumentWebDriver> candidateDocumentDrivers() {
            Iterable<String> windowHandles = this.candidateHandles();
            return FluentIterable.from(windowHandles).transform((Function)new HandleToWindowWebDriver());
        }

        protected Iterable<String> candidateHandles() {
            return FluentIterable.from((Iterable)this.nativeWebDriver().getWindowHandles());
        }

        public String toString() {
            String parentStr = this.parent().toString();
            return (Strings.isNullOrEmpty((String)parentStr) ? "$(\":root\")" : parentStr) + ".windows()";
        }

        protected final class HandleToWindowWebDriver
        implements Function<String, DocumentWebDriver> {
            protected HandleToWindowWebDriver() {
            }

            public DocumentWebDriver apply(String windowHandle) {
                return new WindowWebDriver(WindowRoots.this.nativeWebDriver(), windowHandle);
            }
        }
    }

    protected static class FrameRoots<T extends WebElements>
    extends BaseDocumentRoots<T> {
        private final T frameElems;

        public FrameRoots(T frameElems) {
            this.frameElems = frameElems;
        }

        @Override
        public Iterable<DocumentWebDriver> candidateDocumentDrivers() {
            return FluentIterable.from(((InternalWebElements)this.frameElems.as(InternalWebElements.class)).wrappedNativeElements()).transform((Function)new FrameDocumentDriverCreator());
        }

        public String toString() {
            String parentStr = this.parent().toString();
            return (Strings.isNullOrEmpty((String)parentStr) ? "$(\":root\")" : parentStr) + ".frames()";
        }

        private final class FrameDocumentDriverCreator
        implements Function<DocumentWebElement, DocumentWebDriver> {
            private FrameDocumentDriverCreator() {
            }

            public DocumentWebDriver apply(DocumentWebElement webElement) {
                return new FrameWebDriver(webElement);
            }
        }
    }
}

