/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal;

import java.util.regex.Pattern;

public class CssSelectors {
    private static final Pattern PATTERN = Pattern.compile("('|:|\"|!|;|,|\\.|\\*|\\+|\\||\\[|\\]|\\(|\\)|\\/|\\^|\\$)");

    public static String attr(String name, String val) {
        return String.format("[%s=%s]", name, CssSelectors.escape(val));
    }

    private static String escape(String val) {
        return PATTERN.matcher(val).replaceAll("\\\\$1");
    }

    public static String className(String name) {
        return String.format(".%s", CssSelectors.escape(name));
    }

    public static String tagName(String name) {
        return CssSelectors.escape(name);
    }
}

