/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.rest.dto;

import cucumber.api.Scenario;
import java.util.ArrayList;
import java.util.List;

public class ScenarioDTO {
    private String id;
    private String name;
    private List<String> sourceTagNames;
    private String status;
    private boolean failed;
    private List<Data> embedded = new ArrayList<Data>();
    private List<String> texts = new ArrayList<String>();

    public ScenarioDTO() {
    }

    public ScenarioDTO(Scenario scenario) {
        this.status = scenario.getStatus();
        this.sourceTagNames = new ArrayList<String>(scenario.getSourceTagNames());
        this.failed = scenario.isFailed();
        this.name = scenario.getName();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getSourceTagNames() {
        return this.sourceTagNames;
    }

    public void setSourceTagNames(List<String> sourceTagNames) {
        this.sourceTagNames = sourceTagNames;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public List<Data> getEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(List<Data> embedded) {
        this.embedded = embedded;
    }

    public List<String> getTexts() {
        return this.texts;
    }

    public void setTexts(List<String> texts) {
        this.texts = texts;
    }

    public void populate(Scenario scenario) {
        for (Data data : this.embedded) {
            scenario.embed(data.data, data.mimeType);
        }
        for (String text : this.texts) {
            scenario.write(text);
        }
    }

    public static class Data {
        private byte[] data;
        private String mimeType;

        public Data(byte[] data, String mimeType) {
            this.data = data;
            this.mimeType = mimeType;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }
    }
}

