/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.rest;

import cucumber.api.StepDefinitionReporter;
import cucumber.runtime.DuplicateStepDefinitionException;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.StepDefinitionMatch;
import gherkin.I18n;
import gherkin.formatter.model.Step;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import minium.cucumber.rest.dto.GlueDTO;

public class SimpleGlue
implements Glue {
    static AtomicLong HOOK_DEF_ID_GENERATOR = new AtomicLong();
    static AtomicLong STEP_DEF_ID_GENERATOR = new AtomicLong();
    private UUID uuid;
    private Map<Long, StepDefinition> stepDefinitions = new HashMap<Long, StepDefinition>();
    private Map<Long, HookDefinition> hookDefinitions = new HashMap<Long, HookDefinition>();
    private Map<Long, HookDefinition> beforeHookDefinitions = new HashMap<Long, HookDefinition>();
    private Map<Long, HookDefinition> afterHookDefinitions = new HashMap<Long, HookDefinition>();

    public SimpleGlue() {
        this.uuid = UUID.randomUUID();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void addStepDefinition(StepDefinition stepDefinition) throws DuplicateStepDefinitionException {
        long id = STEP_DEF_ID_GENERATOR.incrementAndGet();
        this.stepDefinitions.put(id, stepDefinition);
    }

    public void addBeforeHook(HookDefinition hookDefinition) {
        long id = HOOK_DEF_ID_GENERATOR.incrementAndGet();
        this.hookDefinitions.put(id, hookDefinition);
        this.beforeHookDefinitions.put(id, hookDefinition);
    }

    public void addAfterHook(HookDefinition hookDefinition) {
        long id = HOOK_DEF_ID_GENERATOR.incrementAndGet();
        this.hookDefinitions.put(id, hookDefinition);
        this.afterHookDefinitions.put(id, hookDefinition);
    }

    public List<HookDefinition> getBeforeHooks() {
        ArrayList<HookDefinition> beforeHooks = new ArrayList<HookDefinition>();
        beforeHooks.addAll(this.beforeHookDefinitions.values());
        return beforeHooks;
    }

    public List<HookDefinition> getAfterHooks() {
        ArrayList<HookDefinition> afterHooks = new ArrayList<HookDefinition>();
        afterHooks.addAll(this.afterHookDefinitions.values());
        return afterHooks;
    }

    public int hashCode() {
        return this.uuid == null ? System.identityHashCode(this) : this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GlueDTO && this.uuid != null) {
            return this.uuid.equals(((GlueDTO)obj).getUuid());
        }
        return false;
    }

    public StepDefinitionMatch stepDefinitionMatch(String featurePath, Step step, I18n i18n) {
        throw new UnsupportedOperationException("stepDefinitionMatch is not supported in GlueProxy");
    }

    public void reportStepDefinitions(StepDefinitionReporter stepDefinitionReporter) {
        for (StepDefinition stepDefinition : this.stepDefinitions.values()) {
            stepDefinitionReporter.stepDefinition(stepDefinition);
        }
    }

    public StepDefinition stepDefinition(Long id) {
        return this.stepDefinitions.get(id);
    }

    public HookDefinition hookDefinition(Long id) {
        return this.hookDefinitions.get(id);
    }

    public Map<Long, StepDefinition> getStepDefinitions() {
        return this.stepDefinitions;
    }

    public Map<Long, HookDefinition> getBeforeHookDefinitions() {
        return this.beforeHookDefinitions;
    }

    public Map<Long, HookDefinition> getAfterHookDefinitions() {
        return this.afterHookDefinitions;
    }

    public void removeScenarioScopedGlue() {
    }
}

