/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.expression;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import minium.web.internal.expression.Expression;

public interface Expressionizer
extends Function<Object, Expression> {
    public boolean handles(Object var1);

    public Expression apply(Object var1);

    public static class Composite
    implements Expressionizer {
        private final List<Expressionizer> expressionizers = Lists.newArrayList();

        public Composite add(Expressionizer processor) {
            this.expressionizers.add(processor);
            return this;
        }

        public Composite addAll(Collection<? extends Expressionizer> processors) {
            this.expressionizers.addAll(processors);
            return this;
        }

        @Override
        public boolean handles(Object obj) {
            Expressionizer processor = this.expressionizerFor(obj);
            return processor != null;
        }

        @Override
        public Expression apply(Object obj) {
            Expressionizer processor = this.expressionizerFor(obj);
            return processor.apply(obj);
        }

        protected Expressionizer expressionizerFor(Object obj) {
            for (Expressionizer expressionizer : Lists.reverse(this.expressionizers)) {
                if (!expressionizer.handles(obj)) continue;
                return expressionizer;
            }
            return null;
        }
    }
}

