/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.drivers;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.List;
import minium.web.DocumentWebDriver;
import minium.web.internal.drivers.InternalDocumentWebDriver;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.interactions.Locatable;
import org.openqa.selenium.interactions.internal.Coordinates;

public class DocumentWebElement
implements WebElement,
WrapsDriver,
TakesScreenshot,
Locatable {
    private final WebElement webElement;
    private final InternalDocumentWebDriver webDriver;

    public DocumentWebElement(WebElement webElement, DocumentWebDriver webDriver) {
        Preconditions.checkNotNull((Object)webElement);
        Preconditions.checkNotNull((Object)webDriver);
        this.webElement = webElement;
        this.webDriver = (InternalDocumentWebDriver)webDriver;
    }

    public void click() {
        this.webDriver.ensureSwitch();
        this.webElement.click();
    }

    public void submit() {
        this.webDriver.ensureSwitch();
        this.webElement.submit();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.webDriver.ensureSwitch();
        this.webElement.sendKeys(keysToSend);
    }

    public void clear() {
        this.webDriver.ensureSwitch();
        this.webElement.clear();
    }

    public String getTagName() {
        this.webDriver.ensureSwitch();
        return this.webElement.getTagName();
    }

    public String getAttribute(String name) {
        this.webDriver.ensureSwitch();
        return this.webElement.getAttribute(name);
    }

    public boolean isSelected() {
        this.webDriver.ensureSwitch();
        return this.webElement.isSelected();
    }

    public boolean isEnabled() {
        this.webDriver.ensureSwitch();
        return this.webElement.isEnabled();
    }

    public String getText() {
        this.webDriver.ensureSwitch();
        return this.webElement.getText();
    }

    public List<WebElement> findElements(By by) {
        this.webDriver.ensureSwitch();
        return this.webElement.findElements(by);
    }

    public WebElement findElement(By by) {
        this.webDriver.ensureSwitch();
        return this.webElement.findElement(by);
    }

    public boolean isDisplayed() {
        this.webDriver.ensureSwitch();
        return this.webElement.isDisplayed();
    }

    public Point getLocation() {
        this.webDriver.ensureSwitch();
        return this.webElement.getLocation();
    }

    public Dimension getSize() {
        this.webDriver.ensureSwitch();
        return this.webElement.getSize();
    }

    public String getCssValue(String propertyName) {
        this.webDriver.ensureSwitch();
        return this.webElement.getCssValue(propertyName);
    }

    public Coordinates getCoordinates() {
        this.webDriver.ensureSwitch();
        return ((Locatable)this.webElement).getCoordinates();
    }

    public DocumentWebDriver getWrappedDriver() {
        return this.webDriver;
    }

    public WebElement getWrappedWebElement() {
        return this.webElement;
    }

    public <X> X getScreenshotAs(OutputType<X> type) throws WebDriverException {
        this.webDriver.ensureSwitch();
        return (X)this.webElement.getScreenshotAs(type);
    }

    public Rectangle getRect() {
        this.webDriver.ensureSwitch();
        return this.webElement.getRect();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DocumentWebElement)) {
            return false;
        }
        return Objects.equal((Object)this.webElement, (Object)((DocumentWebElement)obj).webElement);
    }

    public int hashCode() {
        return this.webElement.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)DocumentWebElement.class.getSimpleName()).addValue((Object)this.webElement).addValue((Object)this.webDriver).toString();
    }
}

