/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.actions;

import minium.Dimension;
import minium.Elements;
import minium.Offsets;
import minium.Point;
import minium.web.internal.actions.MouseInteraction;
import org.openqa.selenium.WebElement;

public class DragAndDropInteraction
extends MouseInteraction {
    private final Elements target;
    private final Offsets.Offset targetOffset;

    public DragAndDropInteraction(Elements source, Offsets.Offset sourceOffset, Elements target, Offsets.Offset targetOffset) {
        super(source, sourceOffset);
        this.target = target;
        this.targetOffset = targetOffset;
    }

    protected void doPerform() {
        WebElement targetElem = this.getFirstElement(this.target);
        if (this.targetOffset == null) {
            this.getActions().dragAndDrop(this.getFirstElement(), targetElem).perform();
        } else {
            org.openqa.selenium.Dimension size = targetElem.getSize();
            Dimension dimension = new Dimension(size.width, size.height);
            Point offsetPoint = this.targetOffset.offset(dimension);
            this.getActions().dragAndDropBy(this.getFirstElement(), offsetPoint.x(), offsetPoint.y()).perform();
        }
    }
}

