/*
 * Decompiled with CFR 0.152.
 */
package minium.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import minium.internal.Throwables;

public class Paths {
    private static final String CLASSPATH_PROTOCOL = "classpath:";
    private static final String CLASSPATH_WILDCARD_PROTOCOL = "classpath*:";

    public static URL toURL(String urlPath) {
        Preconditions.checkArgument((!urlPath.startsWith(CLASSPATH_WILDCARD_PROTOCOL) ? 1 : 0) != 0, (Object)"path starts with classpath*, use toURLs instead");
        return (URL)Iterables.getFirst(Paths.toURLs(urlPath), null);
    }

    public static List<URL> toURLs(String urlPath) {
        Preconditions.checkNotNull((Object)urlPath);
        ClassLoader loader = (ClassLoader)MoreObjects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)Paths.class.getClassLoader());
        if (urlPath.startsWith(CLASSPATH_PROTOCOL)) {
            String path = urlPath.substring(CLASSPATH_PROTOCOL.length());
            return Paths.singletonOrEmpty(loader.getResource(path));
        }
        if (urlPath.startsWith(CLASSPATH_WILDCARD_PROTOCOL)) {
            String path = urlPath.substring(CLASSPATH_WILDCARD_PROTOCOL.length());
            try {
                return Collections.list(loader.getResources(path));
            }
            catch (IOException e) {
                return Paths.singletonOrEmpty(loader.getResource(path));
            }
        }
        try {
            return Paths.singletonOrEmpty(new URL(urlPath));
        }
        catch (MalformedURLException e) {
            File file = new File(urlPath);
            Preconditions.checkArgument((boolean)file.exists(), (String)"File %s does not exist", (Object)file);
            Preconditions.checkArgument((boolean)file.isFile(), (String)"%s is not a file", (Object)file);
            try {
                return Paths.singletonOrEmpty(file.toURI().toURL());
            }
            catch (MalformedURLException e1) {
                throw Throwables.propagate(e1);
            }
        }
    }

    private static List<URL> singletonOrEmpty(URL resource) {
        return resource == null ? Collections.emptyList() : Collections.singletonList(resource);
    }
}

