/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.utils;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import minium.web.internal.ResourceException;

public class ResourceFunctions {
    public static Function<String, String> classpathFileToStringFunction(ClassLoader classLoader) {
        return new ClasspathFileToStringFunction(classLoader);
    }

    private static class ClasspathFileToStringFunction
    implements Function<String, String> {
        private final ClassLoader classLoader;

        public ClasspathFileToStringFunction(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public String apply(String filePath) {
            try {
                URL resource = this.classLoader.getResource(filePath);
                return Resources.toString((URL)resource, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                throw new ResourceException(e);
            }
        }
    }
}

