/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import minium.web.DocumentWebDriver;
import minium.web.internal.drivers.DocumentWebElement;
import org.openqa.selenium.WebElement;

public class WebElementFunctions {
    public static Function<WebElement, WebElement> unwrap() {
        return new DocumentWebElementUnwrapper();
    }

    public static Function<WebElement, DocumentWebElement> wrap(DocumentWebDriver documentDriver) {
        return new DocumentWebElementWrapper(documentDriver);
    }

    public static Function<WebElement, DocumentWebDriver> unwrapDocumentDriver() {
        return new DocumentWebElementDocumentDriverUnwrapper();
    }

    private static class DocumentWebElementDocumentDriverUnwrapper
    implements Function<WebElement, DocumentWebDriver> {
        private DocumentWebElementDocumentDriverUnwrapper() {
        }

        public DocumentWebDriver apply(WebElement webElement) {
            Preconditions.checkArgument((boolean)(webElement instanceof DocumentWebElement));
            return ((DocumentWebElement)webElement).getWrappedDriver();
        }
    }

    private static class DocumentWebElementWrapper
    implements Function<WebElement, DocumentWebElement> {
        private DocumentWebDriver documentDriver;

        public DocumentWebElementWrapper(DocumentWebDriver documentDriver) {
            this.documentDriver = documentDriver;
        }

        public DocumentWebElement apply(WebElement webElement) {
            if (webElement instanceof DocumentWebElement) {
                return (DocumentWebElement)webElement;
            }
            return new DocumentWebElement(webElement, this.documentDriver);
        }
    }

    private static class DocumentWebElementUnwrapper
    implements Function<WebElement, WebElement> {
        private DocumentWebElementUnwrapper() {
        }

        public WebElement apply(WebElement webElement) {
            return webElement instanceof DocumentWebElement ? ((DocumentWebElement)webElement).getWrappedWebElement() : webElement;
        }
    }
}

