/*
 * Decompiled with CFR 0.152.
 */
package platypus.internal;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import platypus.MixinClass;
import platypus.MixinInitializer;
import platypus.internal.Casts;
import platypus.internal.ProxyInvocationHandler;

public class MixinClassImpl<T>
implements MixinClass<T> {
    static final Logger LOGGER = LoggerFactory.getLogger(MixinClassImpl.class);
    private static final Predicate<Class<?>> OBJECT_OR_INTERFACE = new Predicate<Class<?>>(){

        public boolean apply(Class<?> intf) {
            return intf == Object.class || intf.isInterface();
        }
    };
    final Set<Class<?>> intfs;
    final Constructor<T> proxyConst;

    public MixinClassImpl(Class<?> intf, Class<?> ... others) {
        this(intf, Arrays.asList(others));
    }

    public MixinClassImpl(Class<?> intf, Collection<Class<?>> others) {
        LinkedHashSet intfs = Sets.newLinkedHashSet((Iterable)Iterables.concat(Collections.singleton(intf), others));
        ImmutableSet notIntfs = FluentIterable.from((Iterable)intfs).filter(Predicates.not(OBJECT_OR_INTERFACE)).toSet();
        Preconditions.checkArgument((boolean)notIntfs.isEmpty(), (String)"The following classes are not interfaces or Object.class: %s", (Object[])new Object[]{Joiner.on((String)", ").join((Iterable)notIntfs)});
        this.intfs = ImmutableSet.copyOf((Collection)intfs);
        try {
            Class classClazz = (Class)Casts.unsafeCast(Class.class);
            Class[] intfsArray = (Class[])Iterables.toArray((Iterable)intfs, (Class)classClazz);
            this.proxyConst = (Constructor)Casts.unsafeCast(Proxy.getProxyClass(intf.getClassLoader(), intfsArray).getConstructor(InvocationHandler.class));
        }
        catch (SecurityException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Set<Class<?>> getDeclaredInterfaces() {
        return this.intfs;
    }

    @Override
    public T newInstance(MixinInitializer initializer) {
        try {
            ProxyInvocationHandler proxyInvocationHandler = new ProxyInvocationHandler(this, initializer);
            return proxyInvocationHandler.getProxy();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

