/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.implementation.bytecode.constant.DefaultValue;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.OpenedClassReader;

@HashCodeAndEqualsPlugin.Enhance
public class MemberSubstitution
implements AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper {
    private final MethodGraph.Compiler methodGraphCompiler;
    private final boolean strict;
    private final TypePoolResolver typePoolResolver;
    private final Substitution substitution;

    protected MemberSubstitution(boolean strict) {
        this(MethodGraph.Compiler.DEFAULT, TypePoolResolver.OfImplicitPool.INSTANCE, strict, Substitution.NoOp.INSTANCE);
    }

    private MemberSubstitution(MethodGraph.Compiler methodGraphCompiler, TypePoolResolver typePoolResolver, boolean strict, Substitution substitution) {
        this.methodGraphCompiler = methodGraphCompiler;
        this.typePoolResolver = typePoolResolver;
        this.strict = strict;
        this.substitution = substitution;
    }

    public static MemberSubstitution strict() {
        return new MemberSubstitution(true);
    }

    public static MemberSubstitution relaxed() {
        return new MemberSubstitution(false);
    }

    public WithoutSpecification element(ElementMatcher<? super ByteCodeElement> matcher) {
        return new WithoutSpecification.ForMatchedByteCodeElement(this.methodGraphCompiler, this.typePoolResolver, this.strict, this.substitution, matcher);
    }

    public WithoutSpecification.ForMatchedField field(ElementMatcher<? super FieldDescription.InDefinedShape> matcher) {
        return new WithoutSpecification.ForMatchedField(this.methodGraphCompiler, this.typePoolResolver, this.strict, this.substitution, matcher);
    }

    public WithoutSpecification.ForMatchedMethod method(ElementMatcher<? super MethodDescription> matcher) {
        return new WithoutSpecification.ForMatchedMethod(this.methodGraphCompiler, this.typePoolResolver, this.strict, this.substitution, matcher);
    }

    public WithoutSpecification constructor(ElementMatcher<? super MethodDescription> matcher) {
        return this.invokable(ElementMatchers.isConstructor().and(matcher));
    }

    public WithoutSpecification invokable(ElementMatcher<? super MethodDescription> matcher) {
        return new WithoutSpecification.ForMatchedMethod(this.methodGraphCompiler, this.typePoolResolver, this.strict, this.substitution, matcher);
    }

    public MemberSubstitution with(MethodGraph.Compiler methodGraphCompiler) {
        return new MemberSubstitution(methodGraphCompiler, this.typePoolResolver, this.strict, this.substitution);
    }

    public MemberSubstitution with(TypePoolResolver typePoolResolver) {
        return new MemberSubstitution(this.methodGraphCompiler, typePoolResolver, this.strict, this.substitution);
    }

    public AsmVisitorWrapper.ForDeclaredMethods on(ElementMatcher<? super MethodDescription> matcher) {
        return new AsmVisitorWrapper.ForDeclaredMethods().method(matcher, this);
    }

    @Override
    public MethodVisitor wrap(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, TypePool typePool, int writerFlags, int readerFlags) {
        return new SubstitutingMethodVisitor(methodVisitor, this.methodGraphCompiler, this.strict, this.substitution, instrumentedType, implementationContext, this.typePoolResolver.resolve(instrumentedType, instrumentedMethod, typePool));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!this.methodGraphCompiler.equals(((MemberSubstitution)object).methodGraphCompiler)) {
            return false;
        }
        if (this.strict != ((MemberSubstitution)object).strict) {
            return false;
        }
        if (!this.typePoolResolver.equals(((MemberSubstitution)object).typePoolResolver)) {
            return false;
        }
        return this.substitution.equals(((MemberSubstitution)object).substitution);
    }

    public int hashCode() {
        return (((17 * 31 + this.methodGraphCompiler.hashCode()) * 31 + this.strict) * 31 + this.typePoolResolver.hashCode()) * 31 + this.substitution.hashCode();
    }

    protected static class SubstitutingMethodVisitor
    extends MethodVisitor {
        private final MethodGraph.Compiler methodGraphCompiler;
        private final boolean strict;
        private final Substitution substitution;
        private final TypeDescription instrumentedType;
        private final Implementation.Context implementationContext;
        private final TypePool typePool;
        private int stackSizeBuffer;

        protected SubstitutingMethodVisitor(MethodVisitor methodVisitor, MethodGraph.Compiler methodGraphCompiler, boolean strict, Substitution substitution, TypeDescription instrumentedType, Implementation.Context implementationContext, TypePool typePool) {
            super(OpenedClassReader.ASM_API, methodVisitor);
            this.methodGraphCompiler = methodGraphCompiler;
            this.strict = strict;
            this.substitution = substitution;
            this.instrumentedType = instrumentedType;
            this.implementationContext = implementationContext;
            this.typePool = typePool;
            this.stackSizeBuffer = 0;
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String internalName, String descriptor) {
            TypePool.Resolution resolution = this.typePool.describe(owner.replace('/', '.'));
            if (resolution.isResolved()) {
                FieldList candidates = (FieldList)resolution.resolve().getDeclaredFields().filter(ElementMatchers.named(internalName).and(ElementMatchers.hasDescriptor(descriptor)));
                if (!candidates.isEmpty()) {
                    Substitution.Resolver resolver = this.substitution.resolve((FieldDescription.InDefinedShape)candidates.getOnly(), opcode == 181 || opcode == 179);
                    if (resolver.isResolved()) {
                        TypeDescription.Generic result;
                        AbstractList arguments;
                        switch (opcode) {
                            case 181: {
                                arguments = new TypeList.Generic.Explicit(((FieldDescription.InDefinedShape)candidates.getOnly()).getDeclaringType(), ((FieldDescription.InDefinedShape)candidates.getOnly()).getType());
                                result = TypeDescription.Generic.VOID;
                                break;
                            }
                            case 179: {
                                arguments = new TypeList.Generic.Explicit(((FieldDescription.InDefinedShape)candidates.getOnly()).getType());
                                result = TypeDescription.Generic.VOID;
                                break;
                            }
                            case 180: {
                                arguments = new TypeList.Generic.Explicit(((FieldDescription.InDefinedShape)candidates.getOnly()).getDeclaringType());
                                result = ((FieldDescription.InDefinedShape)candidates.getOnly()).getType();
                                break;
                            }
                            case 178: {
                                arguments = new TypeList.Generic.Empty();
                                result = ((FieldDescription.InDefinedShape)candidates.getOnly()).getType();
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        resolver.apply(this.instrumentedType, (ByteCodeElement)candidates.getOnly(), (TypeList.Generic)((Object)arguments), result).apply(this.mv, this.implementationContext);
                        return;
                    }
                } else if (this.strict) {
                    throw new IllegalStateException("Could not resolve " + owner.replace('/', '.') + "." + internalName + descriptor + " using " + this.typePool);
                }
            } else if (this.strict) {
                throw new IllegalStateException("Could not resolve " + owner.replace('/', '.') + " using " + this.typePool);
            }
            super.visitFieldInsn(opcode, owner, internalName, descriptor);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String internalName, String descriptor, boolean isInterface) {
            TypePool.Resolution resolution = this.typePool.describe(owner.replace('/', '.'));
            if (resolution.isResolved()) {
                MethodList candidates;
                if (opcode == 183 && internalName.equals("<init>")) {
                    candidates = (MethodList)resolution.resolve().getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.hasDescriptor(descriptor)));
                } else if (opcode == 184 || opcode == 183) {
                    candidates = (MethodList)resolution.resolve().getDeclaredMethods().filter(ElementMatchers.named(internalName).and(ElementMatchers.hasDescriptor(descriptor)));
                } else {
                    TypeDescription typeDescription = resolution.resolve();
                    candidates = (MethodList)((MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.isPrivate().and(ElementMatchers.not(ElementMatchers.isStatic())))).filter(ElementMatchers.named(internalName).and(ElementMatchers.hasDescriptor(descriptor)));
                    if (candidates.isEmpty()) {
                        candidates = (MethodList)this.methodGraphCompiler.compile(resolution.resolve()).listNodes().asMethodList().filter(ElementMatchers.named(internalName).and(ElementMatchers.hasDescriptor(descriptor)));
                    }
                }
                if (!candidates.isEmpty()) {
                    Substitution.Resolver resolver = this.substitution.resolve((MethodDescription)candidates.getOnly(), Substitution.InvocationType.of(opcode, (MethodDescription)candidates.getOnly()));
                    if (resolver.isResolved()) {
                        resolver.apply(this.instrumentedType, (ByteCodeElement)candidates.getOnly(), ((MethodDescription)candidates.getOnly()).isStatic() || ((MethodDescription)candidates.getOnly()).isConstructor() ? ((MethodDescription)candidates.getOnly()).getParameters().asTypeList() : new TypeList.Generic.Explicit(CompoundList.of(((MethodDescription)candidates.getOnly()).getDeclaringType(), ((MethodDescription)candidates.getOnly()).getParameters().asTypeList())), ((MethodDescription)candidates.getOnly()).isConstructor() ? ((MethodDescription)candidates.getOnly()).getDeclaringType().asGenericType() : ((MethodDescription)candidates.getOnly()).getReturnType()).apply(this.mv, this.implementationContext);
                        if (((MethodDescription)candidates.getOnly()).isConstructor()) {
                            this.stackSizeBuffer = new StackManipulation.Compound(Duplication.SINGLE.flipOver(TypeDescription.OBJECT), Removal.SINGLE, Removal.SINGLE, Duplication.SINGLE.flipOver(TypeDescription.OBJECT), Removal.SINGLE, Removal.SINGLE).apply(this.mv, this.implementationContext).getMaximalSize() + StackSize.SINGLE.getSize();
                        }
                        return;
                    }
                } else if (this.strict) {
                    throw new IllegalStateException("Could not resolve " + owner.replace('/', '.') + "." + internalName + descriptor + " using " + this.typePool);
                }
            } else if (this.strict) {
                throw new IllegalStateException("Could not resolve " + owner.replace('/', '.') + " using " + this.typePool);
            }
            super.visitMethodInsn(opcode, owner, internalName, descriptor, isInterface);
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            super.visitMaxs(maxStack + this.stackSizeBuffer, maxLocals);
        }
    }

    protected static interface Substitution {
        public Resolver resolve(FieldDescription.InDefinedShape var1, boolean var2);

        public Resolver resolve(MethodDescription var1, InvocationType var2);

        @HashCodeAndEqualsPlugin.Enhance
        public static class Compound
        implements Substitution {
            private final List<Substitution> substitutions;

            protected Compound(Substitution ... substitution) {
                this(Arrays.asList(substitution));
            }

            protected Compound(List<? extends Substitution> substitutions) {
                this.substitutions = new ArrayList<Substitution>(substitutions.size());
                for (Substitution substitution : substitutions) {
                    if (substitution instanceof Compound) {
                        this.substitutions.addAll(((Compound)substitution).substitutions);
                        continue;
                    }
                    if (substitution instanceof NoOp) continue;
                    this.substitutions.add(substitution);
                }
            }

            @Override
            public Resolver resolve(FieldDescription.InDefinedShape fieldDescription, boolean writeAccess) {
                for (Substitution substitution : this.substitutions) {
                    Resolver resolver = substitution.resolve(fieldDescription, writeAccess);
                    if (!resolver.isResolved()) continue;
                    return resolver;
                }
                return Resolver.Unresolved.INSTANCE;
            }

            @Override
            public Resolver resolve(MethodDescription methodDescription, InvocationType invocationType) {
                for (Substitution substitution : this.substitutions) {
                    Resolver resolver = substitution.resolve(methodDescription, invocationType);
                    if (!resolver.isResolved()) continue;
                    return resolver;
                }
                return Resolver.Unresolved.INSTANCE;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return ((Object)this.substitutions).equals(((Compound)object).substitutions);
            }

            public int hashCode() {
                return 17 * 31 + ((Object)this.substitutions).hashCode();
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForElementMatchers
        implements Substitution {
            private final ElementMatcher<? super FieldDescription.InDefinedShape> fieldMatcher;
            private final ElementMatcher<? super MethodDescription> methodMatcher;
            private final boolean matchFieldRead;
            private final boolean matchFieldWrite;
            private final boolean includeVirtualCalls;
            private final boolean includeSuperCalls;
            private final Resolver resolver;

            protected static Substitution of(ElementMatcher<? super ByteCodeElement> matcher, Resolver resolver) {
                return new ForElementMatchers(matcher, matcher, true, true, true, true, resolver);
            }

            protected static Substitution ofField(ElementMatcher<? super FieldDescription.InDefinedShape> matcher, boolean matchFieldRead, boolean matchFieldWrite, Resolver resolver) {
                return new ForElementMatchers(matcher, ElementMatchers.none(), matchFieldRead, matchFieldWrite, false, false, resolver);
            }

            protected static Substitution ofMethod(ElementMatcher<? super MethodDescription> matcher, boolean includeVirtualCalls, boolean includeSuperCalls, Resolver resolver) {
                return new ForElementMatchers(ElementMatchers.none(), matcher, false, false, includeVirtualCalls, includeSuperCalls, resolver);
            }

            protected ForElementMatchers(ElementMatcher<? super FieldDescription.InDefinedShape> fieldMatcher, ElementMatcher<? super MethodDescription> methodMatcher, boolean matchFieldRead, boolean matchFieldWrite, boolean includeVirtualCalls, boolean includeSuperCalls, Resolver resolver) {
                this.fieldMatcher = fieldMatcher;
                this.methodMatcher = methodMatcher;
                this.matchFieldRead = matchFieldRead;
                this.matchFieldWrite = matchFieldWrite;
                this.includeVirtualCalls = includeVirtualCalls;
                this.includeSuperCalls = includeSuperCalls;
                this.resolver = resolver;
            }

            @Override
            public Resolver resolve(FieldDescription.InDefinedShape fieldDescription, boolean writeAccess) {
                return (writeAccess ? this.matchFieldWrite : this.matchFieldRead) && this.fieldMatcher.matches(fieldDescription) ? this.resolver : Resolver.Unresolved.INSTANCE;
            }

            @Override
            public Resolver resolve(MethodDescription methodDescription, InvocationType invocationType) {
                return invocationType.matches(this.includeVirtualCalls, this.includeSuperCalls) && this.methodMatcher.matches(methodDescription) ? this.resolver : Resolver.Unresolved.INSTANCE;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.fieldMatcher.equals(((ForElementMatchers)object).fieldMatcher)) {
                    return false;
                }
                if (!this.methodMatcher.equals(((ForElementMatchers)object).methodMatcher)) {
                    return false;
                }
                if (this.matchFieldRead != ((ForElementMatchers)object).matchFieldRead) {
                    return false;
                }
                if (this.matchFieldWrite != ((ForElementMatchers)object).matchFieldWrite) {
                    return false;
                }
                if (this.includeVirtualCalls != ((ForElementMatchers)object).includeVirtualCalls) {
                    return false;
                }
                if (this.includeSuperCalls != ((ForElementMatchers)object).includeSuperCalls) {
                    return false;
                }
                return this.resolver.equals(((ForElementMatchers)object).resolver);
            }

            public int hashCode() {
                return ((((((17 * 31 + this.fieldMatcher.hashCode()) * 31 + this.methodMatcher.hashCode()) * 31 + this.matchFieldRead) * 31 + this.matchFieldWrite) * 31 + this.includeVirtualCalls) * 31 + this.includeSuperCalls) * 31 + this.resolver.hashCode();
            }
        }

        public static enum NoOp implements Substitution
        {
            INSTANCE;


            @Override
            public Resolver resolve(FieldDescription.InDefinedShape fieldDescription, boolean writeAccess) {
                return Resolver.Unresolved.INSTANCE;
            }

            @Override
            public Resolver resolve(MethodDescription methodDescription, InvocationType invocationType) {
                return Resolver.Unresolved.INSTANCE;
            }
        }

        public static enum InvocationType {
            VIRTUAL,
            SUPER,
            OTHER;


            protected static InvocationType of(int opcode, MethodDescription methodDescription) {
                switch (opcode) {
                    case 182: 
                    case 185: {
                        return VIRTUAL;
                    }
                    case 183: {
                        return methodDescription.isVirtual() ? SUPER : OTHER;
                    }
                }
                return OTHER;
            }

            protected boolean matches(boolean includeVirtualCalls, boolean includeSuperCalls) {
                switch (this) {
                    case VIRTUAL: {
                        return includeVirtualCalls;
                    }
                    case SUPER: {
                        return includeSuperCalls;
                    }
                }
                return true;
            }
        }

        public static interface Resolver {
            public boolean isResolved();

            public StackManipulation apply(TypeDescription var1, ByteCodeElement var2, TypeList.Generic var3, TypeDescription.Generic var4);

            @HashCodeAndEqualsPlugin.Enhance
            public static class MethodInvoking
            implements Resolver {
                private static final int THIS_REFERENCE = 0;
                private final MethodDescription methodDescription;

                protected MethodInvoking(MethodDescription methodDescription) {
                    this.methodDescription = methodDescription;
                }

                @Override
                public boolean isResolved() {
                    return true;
                }

                @Override
                public StackManipulation apply(TypeDescription instrumentedType, ByteCodeElement target, TypeList.Generic arguments, TypeDescription.Generic result) {
                    TypeList.Generic mapped;
                    if (!this.methodDescription.isAccessibleTo(instrumentedType)) {
                        throw new IllegalStateException(instrumentedType + " cannot access " + this.methodDescription);
                    }
                    TypeList.Generic generic = mapped = this.methodDescription.isStatic() ? this.methodDescription.getParameters().asTypeList() : new TypeList.Generic.Explicit(CompoundList.of(this.methodDescription.getDeclaringType(), this.methodDescription.getParameters().asTypeList()));
                    if (!this.methodDescription.getReturnType().asErasure().isAssignableTo(result.asErasure())) {
                        throw new IllegalStateException("Cannot assign return value of " + this.methodDescription + " to " + result);
                    }
                    if (mapped.size() != arguments.size()) {
                        throw new IllegalStateException("Cannot invoke " + this.methodDescription + " on " + arguments);
                    }
                    for (int index = 0; index < mapped.size(); ++index) {
                        if (((TypeDescription.Generic)mapped.get(index)).asErasure().isAssignableTo(((TypeDescription.Generic)arguments.get(index)).asErasure())) continue;
                        throw new IllegalStateException("Cannot invoke " + this.methodDescription + " on " + arguments);
                    }
                    return this.methodDescription.isVirtual() ? MethodInvocation.invoke(this.methodDescription).virtual(((TypeDescription.Generic)mapped.get(0)).asErasure()) : MethodInvocation.invoke(this.methodDescription);
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.methodDescription.equals(((MethodInvoking)object).methodDescription);
                }

                public int hashCode() {
                    return 17 * 31 + this.methodDescription.hashCode();
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static class FieldAccessing
            implements Resolver {
                private final FieldDescription fieldDescription;

                protected FieldAccessing(FieldDescription fieldDescription) {
                    this.fieldDescription = fieldDescription;
                }

                @Override
                public boolean isResolved() {
                    return true;
                }

                @Override
                public StackManipulation apply(TypeDescription instrumentedType, ByteCodeElement target, TypeList.Generic arguments, TypeDescription.Generic result) {
                    if (!this.fieldDescription.isAccessibleTo(instrumentedType)) {
                        throw new IllegalStateException(instrumentedType + " cannot access " + this.fieldDescription);
                    }
                    if (result.represents(Void.TYPE)) {
                        if (arguments.size() != (this.fieldDescription.isStatic() ? 1 : 2)) {
                            throw new IllegalStateException("Cannot set " + this.fieldDescription + " with " + arguments);
                        }
                        if (!this.fieldDescription.isStatic() && !((TypeDescription.Generic)arguments.get(0)).asErasure().isAssignableTo(this.fieldDescription.getDeclaringType().asErasure())) {
                            throw new IllegalStateException("Cannot set " + this.fieldDescription + " on " + arguments.get(0));
                        }
                        if (!((TypeDescription.Generic)arguments.get(this.fieldDescription.isStatic() ? 0 : 1)).asErasure().isAssignableTo(this.fieldDescription.getType().asErasure())) {
                            throw new IllegalStateException("Cannot set " + this.fieldDescription + " to " + arguments.get(this.fieldDescription.isStatic() ? 0 : 1));
                        }
                        return FieldAccess.forField(this.fieldDescription).write();
                    }
                    if (arguments.size() != (this.fieldDescription.isStatic() ? 0 : 1)) {
                        throw new IllegalStateException("Cannot set " + this.fieldDescription + " with " + arguments);
                    }
                    if (!this.fieldDescription.isStatic() && !((TypeDescription.Generic)arguments.get(0)).asErasure().isAssignableTo(this.fieldDescription.getDeclaringType().asErasure())) {
                        throw new IllegalStateException("Cannot get " + this.fieldDescription + " on " + arguments.get(0));
                    }
                    if (!this.fieldDescription.getType().asErasure().isAssignableTo(result.asErasure())) {
                        throw new IllegalStateException("Cannot get " + this.fieldDescription + " as " + result);
                    }
                    return FieldAccess.forField(this.fieldDescription).read();
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.fieldDescription.equals(((FieldAccessing)object).fieldDescription);
                }

                public int hashCode() {
                    return 17 * 31 + this.fieldDescription.hashCode();
                }
            }

            public static enum Stubbing implements Resolver
            {
                INSTANCE;


                @Override
                public boolean isResolved() {
                    return true;
                }

                @Override
                public StackManipulation apply(TypeDescription instrumentedType, ByteCodeElement target, TypeList.Generic arguments, TypeDescription.Generic result) {
                    ArrayList<StackManipulation> stackManipulations = new ArrayList<StackManipulation>(arguments.size());
                    for (int index = arguments.size() - 1; index >= 0; --index) {
                        stackManipulations.add(Removal.of((TypeDefinition)arguments.get(index)));
                    }
                    return new StackManipulation.Compound(CompoundList.of(stackManipulations, DefaultValue.of(result.asErasure())));
                }
            }

            public static enum Unresolved implements Resolver
            {
                INSTANCE;


                @Override
                public boolean isResolved() {
                    return false;
                }

                @Override
                public StackManipulation apply(TypeDescription instrumentedType, ByteCodeElement target, TypeList.Generic arguments, TypeDescription.Generic result) {
                    throw new IllegalStateException("Cannot apply unresolved resolver");
                }
            }
        }
    }

    public static interface TypePoolResolver {
        public TypePool resolve(TypeDescription var1, MethodDescription var2, TypePool var3);

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForClassFileLocator
        implements TypePoolResolver {
            private final ClassFileLocator classFileLocator;
            private final TypePool.Default.ReaderMode readerMode;

            public ForClassFileLocator(ClassFileLocator classFileLocator) {
                this(classFileLocator, TypePool.Default.ReaderMode.FAST);
            }

            public ForClassFileLocator(ClassFileLocator classFileLocator, TypePool.Default.ReaderMode readerMode) {
                this.classFileLocator = classFileLocator;
                this.readerMode = readerMode;
            }

            public static TypePoolResolver of(ClassLoader classLoader) {
                return new ForClassFileLocator(ClassFileLocator.ForClassLoader.of(classLoader));
            }

            @Override
            public TypePool resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, TypePool typePool) {
                return new TypePool.Default(new TypePool.CacheProvider.Simple(), this.classFileLocator, this.readerMode, typePool);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.classFileLocator.equals(((ForClassFileLocator)object).classFileLocator)) {
                    return false;
                }
                return this.readerMode.equals((Object)((ForClassFileLocator)object).readerMode);
            }

            public int hashCode() {
                return (17 * 31 + this.classFileLocator.hashCode()) * 31 + this.readerMode.hashCode();
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForExplicitPool
        implements TypePoolResolver {
            private final TypePool typePool;

            public ForExplicitPool(TypePool typePool) {
                this.typePool = typePool;
            }

            @Override
            public TypePool resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, TypePool typePool) {
                return this.typePool;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.typePool.equals(((ForExplicitPool)object).typePool);
            }

            public int hashCode() {
                return 17 * 31 + this.typePool.hashCode();
            }
        }

        public static enum OfImplicitPool implements TypePoolResolver
        {
            INSTANCE;


            @Override
            public TypePool resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, TypePool typePool) {
                return typePool;
            }
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static abstract class WithoutSpecification {
        protected final MethodGraph.Compiler methodGraphCompiler;
        protected final TypePoolResolver typePoolResolver;
        protected final boolean strict;
        protected final Substitution substitution;

        protected WithoutSpecification(MethodGraph.Compiler methodGraphCompiler, TypePoolResolver typePoolResolver, boolean strict, Substitution substitution) {
            this.methodGraphCompiler = methodGraphCompiler;
            this.typePoolResolver = typePoolResolver;
            this.strict = strict;
            this.substitution = substitution;
        }

        public MemberSubstitution stub() {
            return new MemberSubstitution(this.methodGraphCompiler, this.typePoolResolver, this.strict, new Substitution.Compound(this.doStub(), this.substitution));
        }

        protected abstract Substitution doStub();

        public MemberSubstitution replaceWith(Field field) {
            return this.replaceWith(new FieldDescription.ForLoadedField(field));
        }

        public MemberSubstitution replaceWith(FieldDescription fieldDescription) {
            return new MemberSubstitution(this.methodGraphCompiler, this.typePoolResolver, this.strict, new Substitution.Compound(this.doReplaceWith(fieldDescription), this.substitution));
        }

        protected abstract Substitution doReplaceWith(FieldDescription var1);

        public MemberSubstitution replaceWith(Method method) {
            return this.replaceWith(new MethodDescription.ForLoadedMethod(method));
        }

        public MemberSubstitution replaceWith(MethodDescription methodDescription) {
            if (!methodDescription.isMethod()) {
                throw new IllegalArgumentException("Cannot use " + methodDescription + " as a replacement");
            }
            return new MemberSubstitution(this.methodGraphCompiler, this.typePoolResolver, this.strict, new Substitution.Compound(this.doReplaceWith(methodDescription), this.substitution));
        }

        protected abstract Substitution doReplaceWith(MethodDescription var1);

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.methodGraphCompiler.equals(((WithoutSpecification)object).methodGraphCompiler)) {
                return false;
            }
            if (!this.typePoolResolver.equals(((WithoutSpecification)object).typePoolResolver)) {
                return false;
            }
            if (this.strict != ((WithoutSpecification)object).strict) {
                return false;
            }
            return this.substitution.equals(((WithoutSpecification)object).substitution);
        }

        public int hashCode() {
            return (((17 * 31 + this.methodGraphCompiler.hashCode()) * 31 + this.typePoolResolver.hashCode()) * 31 + this.strict) * 31 + this.substitution.hashCode();
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForMatchedMethod
        extends WithoutSpecification {
            private final ElementMatcher<? super MethodDescription> matcher;
            private final boolean includeVirtualCalls;
            private final boolean includeSuperCalls;

            protected ForMatchedMethod(MethodGraph.Compiler methodGraphCompiler, TypePoolResolver typePoolResolver, boolean strict, Substitution substitution, ElementMatcher<? super MethodDescription> matcher) {
                this(methodGraphCompiler, typePoolResolver, strict, substitution, matcher, true, true);
            }

            protected ForMatchedMethod(MethodGraph.Compiler methodGraphCompiler, TypePoolResolver typePoolResolver, boolean strict, Substitution substitution, ElementMatcher<? super MethodDescription> matcher, boolean includeVirtualCalls, boolean includeSuperCalls) {
                super(methodGraphCompiler, typePoolResolver, strict, substitution);
                this.matcher = matcher;
                this.includeVirtualCalls = includeVirtualCalls;
                this.includeSuperCalls = includeSuperCalls;
            }

            public WithoutSpecification onVirtualCall() {
                return new ForMatchedMethod(this.methodGraphCompiler, this.typePoolResolver, this.strict, this.substitution, ElementMatchers.isVirtual().and(this.matcher), true, false);
            }

            public WithoutSpecification onSuperCall() {
                return new ForMatchedMethod(this.methodGraphCompiler, this.typePoolResolver, this.strict, this.substitution, ElementMatchers.isVirtual().and(this.matcher), false, true);
            }

            @Override
            protected Substitution doStub() {
                return Substitution.ForElementMatchers.ofMethod(this.matcher, this.includeVirtualCalls, this.includeSuperCalls, Substitution.Resolver.Stubbing.INSTANCE);
            }

            @Override
            protected Substitution doReplaceWith(FieldDescription fieldDescription) {
                return Substitution.ForElementMatchers.ofMethod(this.matcher, this.includeVirtualCalls, this.includeSuperCalls, new Substitution.Resolver.FieldAccessing(fieldDescription));
            }

            @Override
            protected Substitution doReplaceWith(MethodDescription methodDescription) {
                return Substitution.ForElementMatchers.ofMethod(this.matcher, this.includeVirtualCalls, this.includeSuperCalls, new Substitution.Resolver.MethodInvoking(methodDescription));
            }

            @Override
            public boolean equals(Object object) {
                if (!super.equals(object)) {
                    return false;
                }
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.matcher.equals(((ForMatchedMethod)object).matcher)) {
                    return false;
                }
                if (this.includeVirtualCalls != ((ForMatchedMethod)object).includeVirtualCalls) {
                    return false;
                }
                return this.includeSuperCalls == ((ForMatchedMethod)object).includeSuperCalls;
            }

            @Override
            public int hashCode() {
                return ((super.hashCode() * 31 + this.matcher.hashCode()) * 31 + this.includeVirtualCalls) * 31 + this.includeSuperCalls;
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class ForMatchedField
        extends WithoutSpecification {
            private final ElementMatcher<? super FieldDescription.InDefinedShape> matcher;
            private final boolean matchRead;
            private final boolean matchWrite;

            protected ForMatchedField(MethodGraph.Compiler methodGraphCompiler, TypePoolResolver typePoolResolver, boolean strict, Substitution substitution, ElementMatcher<? super FieldDescription.InDefinedShape> matcher) {
                this(methodGraphCompiler, typePoolResolver, strict, substitution, matcher, true, true);
            }

            protected ForMatchedField(MethodGraph.Compiler methodGraphCompiler, TypePoolResolver typePoolResolver, boolean strict, Substitution substitution, ElementMatcher<? super FieldDescription.InDefinedShape> matcher, boolean matchRead, boolean matchWrite) {
                super(methodGraphCompiler, typePoolResolver, strict, substitution);
                this.matcher = matcher;
                this.matchRead = matchRead;
                this.matchWrite = matchWrite;
            }

            public WithoutSpecification onRead() {
                return new ForMatchedField(this.methodGraphCompiler, this.typePoolResolver, this.strict, this.substitution, this.matcher, true, false);
            }

            public WithoutSpecification onWrite() {
                return new ForMatchedField(this.methodGraphCompiler, this.typePoolResolver, this.strict, this.substitution, this.matcher, false, true);
            }

            @Override
            protected Substitution doStub() {
                return Substitution.ForElementMatchers.ofField(this.matcher, this.matchRead, this.matchWrite, Substitution.Resolver.Stubbing.INSTANCE);
            }

            @Override
            protected Substitution doReplaceWith(FieldDescription fieldDescription) {
                return Substitution.ForElementMatchers.ofField(this.matcher, this.matchRead, this.matchWrite, new Substitution.Resolver.FieldAccessing(fieldDescription));
            }

            @Override
            protected Substitution doReplaceWith(MethodDescription methodDescription) {
                return Substitution.ForElementMatchers.ofField(this.matcher, this.matchRead, this.matchWrite, new Substitution.Resolver.MethodInvoking(methodDescription));
            }

            @Override
            public boolean equals(Object object) {
                if (!super.equals(object)) {
                    return false;
                }
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.matcher.equals(((ForMatchedField)object).matcher)) {
                    return false;
                }
                if (this.matchRead != ((ForMatchedField)object).matchRead) {
                    return false;
                }
                return this.matchWrite == ((ForMatchedField)object).matchWrite;
            }

            @Override
            public int hashCode() {
                return ((super.hashCode() * 31 + this.matcher.hashCode()) * 31 + this.matchRead) * 31 + this.matchWrite;
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        protected static class ForMatchedByteCodeElement
        extends WithoutSpecification {
            private final ElementMatcher<? super ByteCodeElement> matcher;

            protected ForMatchedByteCodeElement(MethodGraph.Compiler methodGraphCompiler, TypePoolResolver typePoolResolver, boolean strict, Substitution substitution, ElementMatcher<? super ByteCodeElement> matcher) {
                super(methodGraphCompiler, typePoolResolver, strict, substitution);
                this.matcher = matcher;
            }

            @Override
            protected Substitution doStub() {
                return Substitution.ForElementMatchers.of(this.matcher, Substitution.Resolver.Stubbing.INSTANCE);
            }

            @Override
            protected Substitution doReplaceWith(FieldDescription fieldDescription) {
                return Substitution.ForElementMatchers.of(this.matcher, new Substitution.Resolver.FieldAccessing(fieldDescription));
            }

            @Override
            protected Substitution doReplaceWith(MethodDescription methodDescription) {
                return Substitution.ForElementMatchers.of(this.matcher, new Substitution.Resolver.MethodInvoking(methodDescription));
            }

            @Override
            public boolean equals(Object object) {
                if (!super.equals(object)) {
                    return false;
                }
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.matcher.equals(((ForMatchedByteCodeElement)object).matcher);
            }

            @Override
            public int hashCode() {
                return super.hashCode() * 31 + this.matcher.hashCode();
            }
        }
    }
}

