/*
 * Decompiled with CFR 0.152.
 */
package minium.developer.fs.web.method.support;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import minium.developer.fs.web.method.support.AntPath;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerMapping;

@Component
public class AntPathHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final String URL_PATH_SEPARATOR = "/";

    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        String param;
        String parameter;
        HttpServletRequest request = ((ServletWebRequest)webRequest).getRequest();
        AntPath antMatcherPath = (AntPath)methodParameter.getParameterAnnotation(AntPath.class);
        if (!antMatcherPath.value().isEmpty() && (parameter = request.getParameter(param = antMatcherPath.value())) != null) {
            return parameter;
        }
        String pattern = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        String extractedPaths = new AntPathMatcher().extractPathWithinPattern(pattern, path);
        return this.decode(extractedPaths);
    }

    public boolean supportsParameter(MethodParameter methodParameter) {
        AntPath antMatcherPath = (AntPath)methodParameter.getParameterAnnotation(AntPath.class);
        return antMatcherPath != null;
    }

    String decode(String extractedPaths) {
        return Joiner.on((String)URL_PATH_SEPARATOR).join((Iterable)Collections2.transform(Arrays.asList(extractedPaths.split(URL_PATH_SEPARATOR)), (Function)new Function<String, String>(){

            public String apply(String input) {
                try {
                    return URLDecoder.decode(input, Charsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    return input;
                }
            }
        }));
    }
}

