/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.actions;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import minium.Dimension;
import minium.Elements;
import minium.FindElements;
import minium.Point;
import minium.actions.Configuration;
import minium.actions.Duration;
import minium.actions.ExceptionHandler;
import minium.actions.HasConfiguration;
import minium.actions.InteractionListener;
import minium.actions.internal.AbstractInteraction;
import minium.internal.HasElementsFactory;
import minium.web.BasicWebElements;
import minium.web.DocumentWebDriver;
import minium.web.TargetLocatorWebElements;
import minium.web.WebElements;
import minium.web.actions.Browser;
import minium.web.actions.WebConfiguration;
import minium.web.internal.InternalWebElements;
import minium.web.internal.WebElementsFactory;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.OutputType;
import platypus.Mixin;

public class InternalBrowser<T extends WebElements>
implements Browser<T> {
    private final TypeToken<T> typeVariableToken = new TypeToken<T>(this.getClass()){};
    private final WebElementsFactory<T> factory;
    private final T elems;

    public InternalBrowser(WebElementsFactory<T> factory) {
        this.factory = factory;
        this.elems = (WebElements)factory.createRoot();
    }

    public InternalBrowser(T elems) {
        this.factory = (WebElementsFactory)((HasElementsFactory)elems.as(HasElementsFactory.class)).factory();
        this.elems = elems;
    }

    @Override
    public T root() {
        return (T)((WebElements)((TargetLocatorWebElements)this.elems.as(TargetLocatorWebElements.class)).documentRoots().as(this.typeVariableToken));
    }

    @Override
    public T $(String selector) {
        return (T)((WebElements)((FindElements)this.root().as(FindElements.class)).find(selector).as(this.typeVariableToken));
    }

    @Override
    public T $(WebElements ... elems) {
        if (elems == null || elems.length == 0) {
            return this.factory.createEmpty(this.documentDriver());
        }
        WebElements result = null;
        for (WebElements webElements : elems) {
            result = result == null ? (WebElements)webElements.as(this.typeVariableToken) : (WebElements)((BasicWebElements)result.as(BasicWebElements.class)).add(webElements).as(this.typeVariableToken);
        }
        return (T)result;
    }

    @Override
    public void get(final String url) {
        new AbstractInteraction((Elements)this.elems){

            protected void doPerform() {
                InternalBrowser.this.documentDriver().get(url);
            }
        }.perform();
    }

    @Override
    public String getCurrentUrl() {
        return this.documentDriver().getCurrentUrl();
    }

    @Override
    public String getTitle() {
        return this.documentDriver().getTitle();
    }

    @Override
    public void close() {
        new AbstractInteraction((Elements)this.elems){

            protected void doPerform() {
                InternalBrowser.this.documentDriver().close();
            }
        }.perform();
    }

    @Override
    public void quit() {
        this.documentDriver().quit();
    }

    @Override
    public Browser.Navigation navigate() {
        return new InternalNavigation();
    }

    @Override
    public WebConfiguration configure() {
        return new InternalWebConfiguration();
    }

    @Override
    public Browser.Screenshot screenshot() {
        return new InternalScreenshot();
    }

    protected DocumentWebDriver documentDriver() {
        return ((InternalWebElements)this.elems.as(InternalWebElements.class)).documentDriver();
    }

    class InternalScreenshot
    implements Browser.Screenshot {
        InternalScreenshot() {
        }

        @Override
        public byte[] asBytes() {
            return (byte[])InternalBrowser.this.documentDriver().getScreenshotAs(OutputType.BYTES);
        }

        @Override
        public File asFile() {
            return (File)InternalBrowser.this.documentDriver().getScreenshotAs(OutputType.FILE);
        }

        @Override
        public void saveTo(File file) throws IOException {
            Files.asByteSource((File)this.asFile()).copyTo(Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]));
        }

        @Override
        public void saveTo(String path) throws IOException {
            File file = new File(path);
            this.saveTo(file);
        }
    }

    class InternalCookie
    implements minium.web.actions.Cookie {
        private Cookie nativeCookie;

        public InternalCookie(Cookie nativeCookie) {
            this.nativeCookie = nativeCookie;
        }

        @Override
        public String getName() {
            return this.nativeCookie.getName();
        }

        @Override
        public String getValue() {
            return this.nativeCookie.getValue();
        }

        @Override
        public String getDomain() {
            return this.nativeCookie.getDomain();
        }

        @Override
        public String getPath() {
            return this.nativeCookie.getPath();
        }

        @Override
        public boolean isSecure() {
            return this.nativeCookie.isSecure();
        }

        @Override
        public boolean isHttpOnly() {
            return this.nativeCookie.isHttpOnly();
        }

        @Override
        public Date getExpiry() {
            return this.nativeCookie.getExpiry();
        }
    }

    class InternalCookieCollection
    implements WebConfiguration.CookieCollection {
        InternalCookieCollection() {
        }

        @Override
        public Iterator<minium.web.actions.Cookie> iterator() {
            return FluentIterable.from((Iterable)InternalBrowser.this.documentDriver().manage().getCookies()).transform((Function)new Function<Cookie, minium.web.actions.Cookie>(){

                public minium.web.actions.Cookie apply(Cookie nativeCookie) {
                    return new InternalCookie(nativeCookie);
                }
            }).iterator();
        }

        @Override
        public WebConfiguration.CookieCollection add(minium.web.actions.Cookie cookie) {
            return this;
        }

        @Override
        public WebConfiguration.CookieCollection remove(String name) {
            InternalBrowser.this.documentDriver().manage().deleteCookieNamed(name);
            return this;
        }

        @Override
        public WebConfiguration.CookieCollection remove(minium.web.actions.Cookie cookie) {
            return this.remove(cookie.getName());
        }

        @Override
        public WebConfiguration.CookieCollection clear() {
            InternalBrowser.this.documentDriver().manage().deleteAllCookies();
            return this;
        }

        @Override
        public minium.web.actions.Cookie get(String name) {
            Cookie nativeCookie = InternalBrowser.this.documentDriver().manage().getCookieNamed(name);
            return nativeCookie == null ? null : new InternalCookie(nativeCookie);
        }

        @Override
        public WebConfiguration done() {
            return InternalBrowser.this.configure();
        }
    }

    class InternalWebConfiguration
    extends Mixin.Impl
    implements WebConfiguration,
    Configuration {
        InternalWebConfiguration() {
        }

        @Override
        public WebConfiguration.CookieCollection cookies() {
            return new InternalCookieCollection();
        }

        @Override
        public WebConfiguration.Window window() {
            return new InternalWindow();
        }

        public Duration defaultTimeout() {
            return this.getConfiguration().defaultTimeout();
        }

        public Configuration defaultTimeout(Duration defaultTimeout) {
            this.getConfiguration().defaultTimeout(defaultTimeout);
            return this;
        }

        public Configuration defaultTimeout(long time, TimeUnit unit) {
            this.getConfiguration().defaultTimeout(time, unit);
            return this;
        }

        public Duration defaultInterval() {
            return this.getConfiguration().defaultInterval();
        }

        public Configuration defaultInterval(Duration defaultInterval) {
            this.getConfiguration().defaultInterval(defaultInterval);
            return this;
        }

        public Configuration defaultInterval(long time, TimeUnit unit) {
            this.getConfiguration().defaultInterval(time, unit);
            return this;
        }

        public Configuration.WaitingPreset waitingPreset(String preset) {
            final Configuration.WaitingPreset waitingPreset = this.getConfiguration().waitingPreset(preset);
            return new Configuration.WaitingPreset(){

                public Duration timeout() {
                    return waitingPreset.timeout();
                }

                public Configuration.WaitingPreset timeout(long time, TimeUnit unit) {
                    waitingPreset.timeout(time, unit);
                    return this;
                }

                public Configuration.WaitingPreset timeout(Duration timeout) {
                    waitingPreset.timeout(timeout);
                    return this;
                }

                public Configuration.WaitingPreset reset() {
                    waitingPreset.reset();
                    return this;
                }

                public Duration interval() {
                    return waitingPreset.interval();
                }

                public Configuration.WaitingPreset interval(long time, TimeUnit unit) {
                    waitingPreset.interval(time, unit);
                    return this;
                }

                public Configuration.WaitingPreset interval(Duration interval) {
                    waitingPreset.interval(interval);
                    return this;
                }

                public Configuration done() {
                    return InternalWebConfiguration.this;
                }
            };
        }

        public Configuration.InteractionListenerCollection interactionListeners() {
            final Configuration.InteractionListenerCollection interactionListeners = this.getConfiguration().interactionListeners();
            return new Configuration.InteractionListenerCollection(){

                public Iterator<InteractionListener> iterator() {
                    return interactionListeners.iterator();
                }

                public Configuration.InteractionListenerCollection remove(InteractionListener interactionListener) {
                    interactionListeners.remove(interactionListener);
                    return this;
                }

                public Configuration done() {
                    return InternalWebConfiguration.this;
                }

                public Configuration.InteractionListenerCollection clear() {
                    interactionListeners.clear();
                    return this;
                }

                public Configuration.InteractionListenerCollection add(InteractionListener interactionListener) {
                    interactionListeners.add(interactionListener);
                    return this;
                }
            };
        }

        public Configuration.ExceptionHandlerCollection exceptionHandlers() {
            final Configuration.ExceptionHandlerCollection exceptionHandlers = this.getConfiguration().exceptionHandlers();
            return new Configuration.ExceptionHandlerCollection(){

                public Iterator<ExceptionHandler> iterator() {
                    return exceptionHandlers.iterator();
                }

                public Configuration.ExceptionHandlerCollection add(ExceptionHandler exceptionHandler) {
                    exceptionHandlers.add(exceptionHandler);
                    return this;
                }

                public Configuration.ExceptionHandlerCollection remove(ExceptionHandler exceptionHandler) {
                    exceptionHandlers.remove(exceptionHandler);
                    return this;
                }

                public Configuration.ExceptionHandlerCollection clear() {
                    exceptionHandlers.clear();
                    return this;
                }

                public Configuration done() {
                    return InternalWebConfiguration.this;
                }
            };
        }

        private Configuration getConfiguration() {
            return ((HasConfiguration)InternalBrowser.this.elems.as(HasConfiguration.class)).configure();
        }
    }

    class InternalWindow
    implements WebConfiguration.Window {
        InternalWindow() {
        }

        @Override
        public WebConfiguration.Window setSize(final Dimension targetSize) {
            new AbstractInteraction(InternalBrowser.this.elems){

                protected void doPerform() {
                    org.openqa.selenium.Dimension seleniumSize = new org.openqa.selenium.Dimension(targetSize.width(), targetSize.height());
                    InternalBrowser.this.documentDriver().manage().window().setSize(seleniumSize);
                }
            }.perform();
            return this;
        }

        @Override
        public WebConfiguration.Window setPosition(final Point targetPosition) {
            new AbstractInteraction(InternalBrowser.this.elems){

                protected void doPerform() {
                    org.openqa.selenium.Point seleniumPoint = new org.openqa.selenium.Point(targetPosition.x(), targetPosition.y());
                    InternalBrowser.this.documentDriver().manage().window().setPosition(seleniumPoint);
                }
            }.perform();
            return this;
        }

        @Override
        public Dimension getSize() {
            org.openqa.selenium.Dimension size = InternalBrowser.this.documentDriver().manage().window().getSize();
            return new Dimension(size.getWidth(), size.getHeight());
        }

        @Override
        public Point getPosition() {
            org.openqa.selenium.Point position = InternalBrowser.this.documentDriver().manage().window().getPosition();
            return new Point(position.getX(), position.getY());
        }

        @Override
        public void maximize() {
            new AbstractInteraction(InternalBrowser.this.elems){

                protected void doPerform() {
                    InternalBrowser.this.documentDriver().manage().window().maximize();
                }
            }.perform();
        }
    }

    class InternalNavigation
    implements Browser.Navigation {
        InternalNavigation() {
        }

        @Override
        public void back() {
            new AbstractInteraction(InternalBrowser.this.elems){

                protected void doPerform() {
                    InternalBrowser.this.documentDriver().navigate().back();
                }
            }.perform();
        }

        @Override
        public void forward() {
            new AbstractInteraction(InternalBrowser.this.elems){

                protected void doPerform() {
                    InternalBrowser.this.documentDriver().navigate().forward();
                }
            }.perform();
        }

        @Override
        public void to(final String url) {
            new AbstractInteraction(InternalBrowser.this.elems){

                protected void doPerform() {
                    InternalBrowser.this.documentDriver().navigate().to(url);
                }
            }.perform();
        }

        @Override
        public void to(final URL url) {
            new AbstractInteraction(InternalBrowser.this.elems){

                protected void doPerform() {
                    InternalBrowser.this.documentDriver().navigate().to(url);
                }
            }.perform();
        }

        @Override
        public void refresh() {
            new AbstractInteraction(InternalBrowser.this.elems){

                protected void doPerform() {
                    InternalBrowser.this.documentDriver().navigate().refresh();
                }
            }.perform();
        }
    }
}

