/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.internal;

import cucumber.runtime.model.CucumberExamples;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.CucumberScenario;
import cucumber.runtime.model.CucumberScenarioOutline;
import cucumber.runtime.model.CucumberTagStatement;
import java.util.List;
import minium.cucumber.data.ExecutionProgress;
import minium.cucumber.data.ProfilesMatrix;

public class CucumberContext {
    private static ThreadLocal<CucumberContext> cucumberContext = new InheritableThreadLocal<CucumberContext>(){

        @Override
        protected CucumberContext initialValue() {
            return new CucumberContext();
        }
    };
    private ExecutionProgress progress = new ExecutionProgress();

    public static CucumberContext getCurrent() {
        return cucumberContext.get();
    }

    public static void clear() {
        cucumberContext.set(new CucumberContext());
    }

    public ExecutionProgress getProgress() {
        return this.progress;
    }

    public static void setFeatures(List<CucumberFeature> cucumberFeatures) {
        int numberOfScenarios = 0;
        for (CucumberFeature feature : cucumberFeatures) {
            for (CucumberTagStatement scenario : feature.getFeatureElements()) {
                if (scenario instanceof CucumberScenario) {
                    ++numberOfScenarios;
                    continue;
                }
                if (!(scenario instanceof CucumberScenarioOutline)) continue;
                for (CucumberExamples examples : ((CucumberScenarioOutline)scenario).getCucumberExamplesList()) {
                    numberOfScenarios += examples.getExamples().getRows().size() - 1;
                }
            }
        }
        ExecutionProgress currentContextProgress = CucumberContext.getCurrent().getProgress();
        currentContextProgress.setNumberOfFeatures(cucumberFeatures.size());
        currentContextProgress.setNumberOfScenarios(numberOfScenarios);
    }

    public static void setProfilesMatrix(ProfilesMatrix profilesMatrix) {
        CucumberContext.getCurrent().getProgress().setProfilesMatrix(profilesMatrix);
    }
}

