/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.drivers;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import minium.web.internal.drivers.BaseDocumentWebDriver;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowWebDriver
extends BaseDocumentWebDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowWebDriver.class);
    private final String windowHandle;

    public WindowWebDriver(WebDriver webDriver) {
        this(webDriver, null);
    }

    public WindowWebDriver(WebDriver webDriver, String windowHandle) {
        super(webDriver);
        this.windowHandle = windowHandle == null ? webDriver.getWindowHandle() : windowHandle;
    }

    @Override
    public void ensureSwitch() {
        this.webDriver.switchTo().window(this.windowHandle);
        LOGGER.trace("Switched to window {}", (Object)this.windowHandle);
    }

    @Override
    public boolean isClosed() {
        return !this.getWindowHandles().contains(this.windowHandle);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)WindowWebDriver.class.getSimpleName()).addValue((Object)this.windowHandle).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.windowHandle});
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == WindowWebDriver.class && this.equalFields((WindowWebDriver)obj);
    }

    protected boolean equalFields(WindowWebDriver obj) {
        return super.equalFields(obj) && Objects.equal((Object)this.windowHandle, (Object)obj.windowHandle);
    }
}

