/*
 * Decompiled with CFR 0.152.
 */
package minium.web;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefulWebDriver
implements WebDriver,
JavascriptExecutor,
HasInputDevices,
TakesScreenshot {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatefulWebDriver.class);
    protected final WebDriver webDriver;
    private final StatefulTargetLocator statefulTargetLocator;

    public StatefulWebDriver(WebDriver webDriver) {
        Preconditions.checkNotNull((Object)webDriver);
        this.webDriver = webDriver;
        this.statefulTargetLocator = new StatefulTargetLocator();
    }

    public void get(String url) {
        this.webDriver.get(url);
    }

    public String getCurrentUrl() {
        return this.webDriver.getCurrentUrl();
    }

    public String getTitle() {
        return this.webDriver.getCurrentUrl();
    }

    public List<WebElement> findElements(By by) {
        return this.webDriver.findElements(by);
    }

    public WebElement findElement(By by) {
        return this.webDriver.findElement(by);
    }

    public String getPageSource() {
        return this.webDriver.getPageSource();
    }

    public void close() {
        this.webDriver.close();
    }

    public void quit() {
        this.webDriver.quit();
    }

    public Set<String> getWindowHandles() {
        return this.webDriver.getWindowHandles();
    }

    public String getWindowHandle() {
        return this.statefulTargetLocator.getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.statefulTargetLocator;
    }

    public WebDriver.Navigation navigate() {
        return this.webDriver.navigate();
    }

    public WebDriver.Options manage() {
        return this.webDriver.manage();
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        return (X)((TakesScreenshot)this.webDriver).getScreenshotAs(target);
    }

    public Keyboard getKeyboard() {
        return ((HasInputDevices)this.webDriver).getKeyboard();
    }

    public Mouse getMouse() {
        return ((HasInputDevices)this.webDriver).getMouse();
    }

    public Object executeScript(String script, Object ... args) {
        return ((JavascriptExecutor)this.webDriver).executeScript(script, args);
    }

    public Object executeAsyncScript(String script, Object ... args) {
        return ((JavascriptExecutor)this.webDriver).executeAsyncScript(script, args);
    }

    private final class StatefulTargetLocator
    implements WebDriver.TargetLocator {
        private String nameOrHandle;
        private Object frame;

        private StatefulTargetLocator() {
            this.nameOrHandle = StatefulWebDriver.this.webDriver.getWindowHandle();
        }

        public WebDriver window(String nameOrHandle) {
            if (!Objects.equal((Object)nameOrHandle, (Object)this.nameOrHandle)) {
                StatefulWebDriver.this.webDriver.switchTo().window(nameOrHandle);
                LOGGER.trace("Switched window from {} to {}", (Object)this.nameOrHandle, (Object)nameOrHandle);
            } else if (this.frame != null) {
                StatefulWebDriver.this.webDriver.switchTo().defaultContent();
                LOGGER.trace("Switched to default content of window {}", (Object)this.nameOrHandle);
            }
            this.nameOrHandle = nameOrHandle;
            this.frame = null;
            return StatefulWebDriver.this;
        }

        public WebDriver frame(WebElement frameElement) {
            if (!frameElement.equals(this.frame)) {
                StatefulWebDriver.this.webDriver.switchTo().frame(frameElement);
                this.logSwitchFrame(frameElement);
            }
            this.frame = frameElement;
            return StatefulWebDriver.this;
        }

        public WebDriver frame(String nameOrId) {
            if (!nameOrId.equals(this.frame)) {
                StatefulWebDriver.this.webDriver.switchTo().frame(nameOrId);
                this.logSwitchFrame(nameOrId);
            }
            this.frame = nameOrId;
            return StatefulWebDriver.this;
        }

        public WebDriver frame(int index) {
            if (!(this.frame instanceof Integer) || (Integer)this.frame != index) {
                StatefulWebDriver.this.webDriver.switchTo().frame(index);
                this.logSwitchFrame(index);
            }
            this.frame = index;
            return StatefulWebDriver.this;
        }

        public WebDriver defaultContent() {
            if (this.frame != null) {
                StatefulWebDriver.this.webDriver.switchTo().defaultContent();
                LOGGER.trace("Switched to default content of window {}", (Object)this.nameOrHandle);
            }
            this.frame = null;
            return StatefulWebDriver.this;
        }

        public WebDriver parentFrame() {
            throw new UnsupportedOperationException();
        }

        public Alert alert() {
            return StatefulWebDriver.this.webDriver.switchTo().alert();
        }

        public WebElement activeElement() {
            return StatefulWebDriver.this.webDriver.switchTo().activeElement();
        }

        public String getWindowHandle() {
            return this.nameOrHandle;
        }

        protected void logSwitchFrame(Object frame) {
            if (this.frame == null) {
                LOGGER.trace("Switched to frame {} of window {}", frame, (Object)this.nameOrHandle);
            } else {
                LOGGER.trace("Switched from frame {} to frame {} of window {}", new Object[]{this.frame, frame, this.nameOrHandle});
            }
        }
    }
}

