/*
 * Decompiled with CFR 0.152.
 */
package minium.web;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.Logs;

public class DelegatorWebDriver
extends Observable
implements WebDriver,
JavascriptExecutor,
HasInputDevices,
TakesScreenshot {
    private WebDriver delegate;

    public void setDelegate(WebDriver delegate) {
        if (this.delegate != delegate) {
            this.setChanged();
            this.delegate = delegate;
            this.notifyObservers(delegate);
        }
    }

    public WebDriver getDelegate() {
        return this.delegate;
    }

    public boolean isValid() {
        if (this.delegate == null) {
            return false;
        }
        try {
            return this.delegate.getWindowHandles() != null && this.delegate.getWindowHandles().size() > 0;
        }
        catch (WebDriverException e) {
            return e instanceof UnhandledAlertException;
        }
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        this.ensureWebDriver();
        return (X)((TakesScreenshot)this.delegate).getScreenshotAs(target);
    }

    public Keyboard getKeyboard() {
        return new DelegatorKeyboard();
    }

    public Mouse getMouse() {
        return new DelegatorMouse();
    }

    public Object executeScript(String script, Object ... args) {
        this.ensureWebDriver();
        return ((JavascriptExecutor)this.delegate).executeScript(script, args);
    }

    public Object executeAsyncScript(String script, Object ... args) {
        this.ensureWebDriver();
        return ((JavascriptExecutor)this.delegate).executeAsyncScript(script, args);
    }

    public void get(String url) {
        this.ensureWebDriver();
        this.delegate.get(url);
    }

    public String getCurrentUrl() {
        this.ensureWebDriver();
        return this.delegate.getCurrentUrl();
    }

    public String getTitle() {
        this.ensureWebDriver();
        return this.delegate.getTitle();
    }

    public List<WebElement> findElements(By by) {
        this.ensureWebDriver();
        return this.delegate.findElements(by);
    }

    public WebElement findElement(By by) {
        this.ensureWebDriver();
        return this.delegate.findElement(by);
    }

    public String getPageSource() {
        this.ensureWebDriver();
        return this.delegate.getPageSource();
    }

    public void close() {
        this.ensureWebDriver();
        this.delegate.close();
    }

    public void quit() {
        this.ensureWebDriver();
        this.delegate.quit();
    }

    public Set<String> getWindowHandles() {
        this.ensureWebDriver();
        return this.delegate.getWindowHandles();
    }

    public String getWindowHandle() {
        this.ensureWebDriver();
        return this.delegate.getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        return new DelegatorTargetLocator();
    }

    public WebDriver.Navigation navigate() {
        return new DelegatorNavigation();
    }

    public WebDriver.Options manage() {
        return new DelegatorOptions();
    }

    private WebDriver ensureWebDriver() {
        return (WebDriver)Preconditions.checkNotNull((Object)this.delegate);
    }

    class DelegatorTimeouts
    implements WebDriver.Timeouts {
        DelegatorTimeouts() {
        }

        public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
            DelegatorWebDriver.this.ensureWebDriver();
            DelegatorWebDriver.this.delegate.manage().timeouts().implicitlyWait(time, unit);
            return this;
        }

        public WebDriver.Timeouts setScriptTimeout(long time, TimeUnit unit) {
            DelegatorWebDriver.this.ensureWebDriver();
            DelegatorWebDriver.this.delegate.manage().timeouts().setScriptTimeout(time, unit);
            return this;
        }

        public WebDriver.Timeouts pageLoadTimeout(long time, TimeUnit unit) {
            DelegatorWebDriver.this.ensureWebDriver();
            DelegatorWebDriver.this.delegate.manage().timeouts().pageLoadTimeout(time, unit);
            return this;
        }
    }

    class DelegatorWindow
    implements WebDriver.Window {
        DelegatorWindow() {
        }

        public void setSize(Dimension targetSize) {
            DelegatorWebDriver.this.ensureWebDriver();
            this.delegateWindow().setSize(targetSize);
        }

        public void setPosition(Point targetPosition) {
            DelegatorWebDriver.this.ensureWebDriver();
            this.delegateWindow().setPosition(targetPosition);
        }

        public Dimension getSize() {
            DelegatorWebDriver.this.ensureWebDriver();
            return this.delegateWindow().getSize();
        }

        public Point getPosition() {
            DelegatorWebDriver.this.ensureWebDriver();
            return this.delegateWindow().getPosition();
        }

        public void maximize() {
            DelegatorWebDriver.this.ensureWebDriver();
            this.delegateWindow().maximize();
        }

        public void fullscreen() {
            DelegatorWebDriver.this.ensureWebDriver();
            this.delegateWindow().fullscreen();
        }

        private WebDriver.Window delegateWindow() {
            return DelegatorWebDriver.this.delegate.manage().window();
        }
    }

    class DelegatorImeHandler
    implements WebDriver.ImeHandler {
        DelegatorImeHandler() {
        }

        public List<String> getAvailableEngines() {
            DelegatorWebDriver.this.ensureWebDriver();
            return this.delegateIme().getAvailableEngines();
        }

        public String getActiveEngine() {
            DelegatorWebDriver.this.ensureWebDriver();
            return this.delegateIme().getActiveEngine();
        }

        public boolean isActivated() {
            DelegatorWebDriver.this.ensureWebDriver();
            return this.delegateIme().isActivated();
        }

        public void deactivate() {
            DelegatorWebDriver.this.ensureWebDriver();
            this.delegateIme().deactivate();
        }

        public void activateEngine(String engine) {
            DelegatorWebDriver.this.ensureWebDriver();
            this.delegateIme().activateEngine(engine);
        }

        private WebDriver.ImeHandler delegateIme() {
            return DelegatorWebDriver.this.delegate.manage().ime();
        }
    }

    class DelegatorLogs
    implements Logs {
        DelegatorLogs() {
        }

        public LogEntries get(String logType) {
            DelegatorWebDriver.this.ensureWebDriver();
            return DelegatorWebDriver.this.delegate.manage().logs().get(logType);
        }

        public Set<String> getAvailableLogTypes() {
            DelegatorWebDriver.this.ensureWebDriver();
            return DelegatorWebDriver.this.delegate.manage().logs().getAvailableLogTypes();
        }
    }

    class DelegatorOptions
    implements WebDriver.Options {
        DelegatorOptions() {
        }

        public void addCookie(Cookie cookie) {
            DelegatorWebDriver.this.ensureWebDriver();
            DelegatorWebDriver.this.delegate.manage().addCookie(cookie);
        }

        public void deleteCookieNamed(String name) {
            DelegatorWebDriver.this.ensureWebDriver();
            DelegatorWebDriver.this.delegate.manage().deleteCookieNamed(name);
        }

        public void deleteCookie(Cookie cookie) {
            DelegatorWebDriver.this.ensureWebDriver();
            DelegatorWebDriver.this.delegate.manage().deleteCookie(cookie);
        }

        public void deleteAllCookies() {
            DelegatorWebDriver.this.ensureWebDriver();
            DelegatorWebDriver.this.delegate.manage().deleteAllCookies();
        }

        public Set<Cookie> getCookies() {
            DelegatorWebDriver.this.ensureWebDriver();
            return DelegatorWebDriver.this.delegate.manage().getCookies();
        }

        public Cookie getCookieNamed(String name) {
            DelegatorWebDriver.this.ensureWebDriver();
            return DelegatorWebDriver.this.delegate.manage().getCookieNamed(name);
        }

        public WebDriver.Timeouts timeouts() {
            return new DelegatorTimeouts();
        }

        public WebDriver.ImeHandler ime() {
            return new DelegatorImeHandler();
        }

        public WebDriver.Window window() {
            return new DelegatorWindow();
        }

        public Logs logs() {
            return new DelegatorLogs();
        }
    }

    class DelegatorNavigation
    implements WebDriver.Navigation {
        DelegatorNavigation() {
        }

        public void back() {
            DelegatorWebDriver.this.ensureWebDriver();
            DelegatorWebDriver.this.delegate.navigate().back();
        }

        public void forward() {
            DelegatorWebDriver.this.ensureWebDriver();
            DelegatorWebDriver.this.delegate.navigate().forward();
        }

        public void to(String url) {
            DelegatorWebDriver.this.ensureWebDriver();
            DelegatorWebDriver.this.delegate.navigate().to(url);
        }

        public void to(URL url) {
            DelegatorWebDriver.this.ensureWebDriver();
            DelegatorWebDriver.this.delegate.navigate().to(url);
        }

        public void refresh() {
            DelegatorWebDriver.this.ensureWebDriver();
            DelegatorWebDriver.this.delegate.navigate().refresh();
        }
    }

    class DelegatorTargetLocator
    implements WebDriver.TargetLocator {
        DelegatorTargetLocator() {
        }

        public WebDriver frame(int index) {
            DelegatorWebDriver.this.ensureWebDriver();
            DelegatorWebDriver.this.delegate.switchTo().frame(index);
            return DelegatorWebDriver.this.delegate;
        }

        public WebDriver frame(String nameOrId) {
            DelegatorWebDriver.this.ensureWebDriver();
            DelegatorWebDriver.this.delegate.switchTo().frame(nameOrId);
            return DelegatorWebDriver.this.delegate;
        }

        public WebDriver frame(WebElement frameElement) {
            DelegatorWebDriver.this.ensureWebDriver();
            DelegatorWebDriver.this.delegate.switchTo().frame(frameElement);
            return DelegatorWebDriver.this.delegate;
        }

        public WebDriver parentFrame() {
            DelegatorWebDriver.this.ensureWebDriver();
            DelegatorWebDriver.this.delegate.switchTo().parentFrame();
            return DelegatorWebDriver.this.delegate;
        }

        public WebDriver window(String nameOrHandle) {
            DelegatorWebDriver.this.ensureWebDriver();
            DelegatorWebDriver.this.delegate.switchTo().window(nameOrHandle);
            return DelegatorWebDriver.this.delegate;
        }

        public WebDriver defaultContent() {
            DelegatorWebDriver.this.ensureWebDriver();
            DelegatorWebDriver.this.delegate.switchTo().defaultContent();
            return DelegatorWebDriver.this.delegate;
        }

        public WebElement activeElement() {
            DelegatorWebDriver.this.ensureWebDriver();
            return DelegatorWebDriver.this.delegate.switchTo().activeElement();
        }

        public Alert alert() {
            DelegatorWebDriver.this.ensureWebDriver();
            return DelegatorWebDriver.this.delegate.switchTo().alert();
        }
    }

    class DelegatorKeyboard
    implements Keyboard {
        DelegatorKeyboard() {
        }

        public void sendKeys(CharSequence ... keysToSend) {
            DelegatorWebDriver.this.ensureWebDriver();
            this.delegateKeyboard().sendKeys(keysToSend);
        }

        public void pressKey(CharSequence keyToPress) {
            DelegatorWebDriver.this.ensureWebDriver();
            this.delegateKeyboard().pressKey(keyToPress);
        }

        public void releaseKey(CharSequence keyToRelease) {
            DelegatorWebDriver.this.ensureWebDriver();
            this.delegateKeyboard().releaseKey(keyToRelease);
        }

        protected Keyboard delegateKeyboard() {
            return ((HasInputDevices)DelegatorWebDriver.this.delegate).getKeyboard();
        }
    }

    class DelegatorMouse
    implements Mouse {
        DelegatorMouse() {
        }

        public void click(Coordinates where) {
            DelegatorWebDriver.this.ensureWebDriver();
            this.delegateMouse().click(where);
        }

        public void doubleClick(Coordinates where) {
            DelegatorWebDriver.this.ensureWebDriver();
            this.delegateMouse().doubleClick(where);
        }

        public void mouseDown(Coordinates where) {
            DelegatorWebDriver.this.ensureWebDriver();
            this.delegateMouse().mouseDown(where);
        }

        public void mouseUp(Coordinates where) {
            DelegatorWebDriver.this.ensureWebDriver();
            this.delegateMouse().mouseUp(where);
        }

        public void mouseMove(Coordinates where) {
            DelegatorWebDriver.this.ensureWebDriver();
            this.delegateMouse().mouseMove(where);
        }

        public void mouseMove(Coordinates where, long xOffset, long yOffset) {
            DelegatorWebDriver.this.ensureWebDriver();
            this.delegateMouse().mouseMove(where, xOffset, yOffset);
        }

        public void contextClick(Coordinates where) {
            DelegatorWebDriver.this.ensureWebDriver();
            this.delegateMouse().contextClick(where);
        }

        protected Mouse delegateMouse() {
            return ((HasInputDevices)DelegatorWebDriver.this.delegate).getMouse();
        }
    }
}

