/*
 * Decompiled with CFR 0.152.
 */
package minium.automator.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.OutputStream;
import java.util.Map;
import minium.automator.Application;
import minium.automator.config.AutomatorProperties;
import minium.automator.runners.RhinoScriptCommandLineRunner;
import minium.script.rhinojs.RhinoConfiguration;
import minium.script.rhinojs.RhinoProperties;
import minium.web.config.WebDriverProperties;
import minium.web.config.WebElementsConfiguration;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Configuration
@Import(value={WebElementsConfiguration.class, RhinoConfiguration.class, PropertyPlaceholderAutoConfiguration.class})
public class AutomatorConfiguration {
    private static AutomatorProperties automatorProperties = new AutomatorProperties();

    @Bean
    public AutomatorProperties automatorProperties() {
        return automatorProperties;
    }

    @Bean
    public ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @Autowired
    @Bean
    public RhinoScriptCommandLineRunner rhinoScriptCommandLineRunner() {
        return new RhinoScriptCommandLineRunner();
    }

    @Bean
    @Primary
    public RhinoProperties rhinoProperties(AutomatorProperties automator) {
        RhinoProperties rhinoProperties = new RhinoProperties();
        RhinoProperties.RequireProperties require = new RhinoProperties.RequireProperties();
        if (automator.getModulePaths() != null) {
            require.getModulePaths().addAll(ImmutableList.copyOf((Object[])automator.getModulePaths()));
        }
        rhinoProperties.setRequire(require);
        return rhinoProperties;
    }

    @Bean
    @Primary
    public WebDriverProperties webDriverProperties(AutomatorProperties automator) {
        WebDriverProperties webDriverProperties = new WebDriverProperties();
        ImmutableMap desiredCapabilities = ImmutableMap.of((Object)"browserName", (Object)automator.getBrowser());
        webDriverProperties.setDesiredCapabilities((Map)desiredCapabilities);
        return webDriverProperties;
    }

    public static AutomatorProperties readAutomationProperties(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)automatorProperties);
        boolean showHelp = false;
        boolean showVersion = false;
        try {
            parser.parseArgument(args);
            showHelp = automatorProperties.isHelp();
            showVersion = automatorProperties.isVersion();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            showHelp = true;
        }
        if (showVersion) {
            System.out.println(Application.class.getPackage().getImplementationVersion());
        }
        if (showHelp) {
            System.err.println("minium-automator [options...] arguments...");
            parser.printUsage((OutputStream)System.err);
            System.err.println();
            System.err.println("  Example: minium-automator --browser chrome --file main.js \"user = { name : 'minium', password : 'xxxxxxxx' }\"");
            System.err.println("           minium-automator --browser firefox --dir minium-task");
        }
        return showHelp || showVersion ? null : automatorProperties;
    }
}

