/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.util;

import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.dump.DumpArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.tools.ant.BuildException;

public class EntryHelper {
    public static int UNKNOWN_ID = Integer.MIN_VALUE;

    private EntryHelper() {
    }

    public static int getMode(ArchiveEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("entry must not be null.");
        }
        if (entry instanceof ArArchiveEntry) {
            return ((ArArchiveEntry)entry).getMode();
        }
        if (entry instanceof CpioArchiveEntry) {
            return (int)((CpioArchiveEntry)entry).getMode();
        }
        if (entry instanceof TarArchiveEntry) {
            return ((TarArchiveEntry)entry).getMode();
        }
        if (entry instanceof ZipArchiveEntry) {
            return ((ZipArchiveEntry)entry).getUnixMode();
        }
        if (entry instanceof DumpArchiveEntry) {
            return ((DumpArchiveEntry)entry).getMode();
        }
        throw new BuildException("archive entry " + entry.getClass() + " is not supported.");
    }

    public static int getUserId(ArchiveEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("entry must not be null.");
        }
        if (entry instanceof ArArchiveEntry) {
            return ((ArArchiveEntry)entry).getUserId();
        }
        if (entry instanceof CpioArchiveEntry) {
            return (int)((CpioArchiveEntry)entry).getUID();
        }
        if (entry instanceof TarArchiveEntry) {
            return ((TarArchiveEntry)entry).getUserId();
        }
        if (entry instanceof ZipArchiveEntry) {
            return UNKNOWN_ID;
        }
        if (entry instanceof DumpArchiveEntry) {
            return ((DumpArchiveEntry)entry).getUserId();
        }
        throw new BuildException("archive entry " + entry.getClass() + " is not supported.");
    }

    public static int getGroupId(ArchiveEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("entry must not be null.");
        }
        if (entry instanceof ArArchiveEntry) {
            return ((ArArchiveEntry)entry).getGroupId();
        }
        if (entry instanceof CpioArchiveEntry) {
            return (int)((CpioArchiveEntry)entry).getGID();
        }
        if (entry instanceof TarArchiveEntry) {
            return ((TarArchiveEntry)entry).getGroupId();
        }
        if (entry instanceof ZipArchiveEntry) {
            return UNKNOWN_ID;
        }
        if (entry instanceof DumpArchiveEntry) {
            return ((DumpArchiveEntry)entry).getGroupId();
        }
        throw new BuildException("archive entry " + entry.getClass() + " is not supported.");
    }
}

