/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.rest.dto;

import cucumber.api.DataTable;
import cucumber.runtime.ParameterInfo;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.table.TableConverter;
import cucumber.runtime.xstream.LocalizedXStreams;
import gherkin.I18n;
import gherkin.formatter.model.DocString;
import java.io.Serializable;
import java.lang.reflect.Type;
import minium.cucumber.rest.dto.DataTableDTO;
import minium.cucumber.rest.dto.DocStringDTO;

public class StepDefinitionInvocation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String isoCode;
    private Object[] args;
    private DataTableDTO dataTable;
    private DocStringDTO docString;

    public StepDefinitionInvocation() {
    }

    public StepDefinitionInvocation(I18n isoCode, Object[] args) {
        this.isoCode = isoCode.getIsoCode();
        this.initializeArgs(args);
    }

    public Object[] getArgs(LocalizedXStreams.LocalizedXStream xStream, StepDefinition stepDefinition) {
        Object[] transformedArgs = new Object[this.dataTable == null && this.docString == null ? this.args.length : this.args.length + 1];
        for (int i = 0; i < this.args.length; ++i) {
            Object arg = this.args[i];
            if (arg == null) continue;
            ParameterInfo parameterInfo = this.getParameterType(stepDefinition, i, arg.getClass());
            transformedArgs[i] = parameterInfo.convert(arg.toString(), xStream);
        }
        if (this.dataTable != null) {
            ParameterInfo parameterInfo = this.getParameterType(stepDefinition, this.args.length, (Type)((Object)DataTable.class));
            TableConverter tableConverter = new TableConverter(xStream, parameterInfo);
            DataTable cucumberDataTable = this.dataTable.toDataTable(tableConverter);
            transformedArgs[this.args.length] = tableConverter.convert(cucumberDataTable, parameterInfo.getType(), parameterInfo.isTransposed());
        } else if (this.docString != null) {
            transformedArgs[this.args.length] = this.docString.getValue();
        }
        return transformedArgs;
    }

    public String getIsoCode() {
        return this.isoCode;
    }

    public void setIsoCode(String isoCode) {
        this.isoCode = isoCode;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public void setArgs(Object[] args) {
        this.args = args;
    }

    public DataTableDTO getDataTable() {
        return this.dataTable;
    }

    public void setDataTable(DataTableDTO dataTable) {
        this.dataTable = dataTable;
    }

    public DocStringDTO getDocString() {
        return this.docString;
    }

    public void setDocString(DocStringDTO docString) {
        this.docString = docString;
    }

    protected void initializeArgs(Object[] args) {
        if (args == null) {
            return;
        }
        if (args.length == 0) {
            this.args = new Object[0];
            return;
        }
        int size = args.length;
        Object last = args[size - 1];
        if (last instanceof DataTable) {
            this.dataTable = new DataTableDTO((DataTable)last);
            --size;
        } else if (last instanceof DocString) {
            this.docString = new DocStringDTO((DocString)last);
            --size;
        }
        this.args = new Object[size];
        System.arraycopy(args, 0, this.args, 0, size);
    }

    protected ParameterInfo getParameterType(StepDefinition stepDefinition, int n, Type argumentType) {
        ParameterInfo parameterInfo = stepDefinition.getParameterType(n, argumentType);
        if (parameterInfo == null) {
            parameterInfo = new ParameterInfo(argumentType, null, null, false, null);
        }
        return parameterInfo;
    }
}

