/*
 * Decompiled with CFR 0.152.
 */
package minium.web.config.services;

import java.io.File;
import java.util.Map;
import minium.web.config.services.DriverServiceProperties;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.phantomjs.PhantomJSDriverService;
import org.openqa.selenium.remote.service.DriverService;

public class PhantomJsDriverServiceProperties
extends DriverServiceProperties {
    private File driverExecutable;
    private File ghostDriver;
    private Integer port;
    private Map<String, String> environment;
    private File logFile;
    private Map<String, Object> proxy;
    private String[] commandLineArguments;
    private String[] ghostDriverCommandLineArguments;

    public File getDriverExecutable() {
        return this.driverExecutable;
    }

    public void setDriverExecutable(File driverExecutable) {
        this.driverExecutable = driverExecutable;
    }

    public File getGhostDriver() {
        return this.ghostDriver;
    }

    public void setGhostDriver(File ghostDriver) {
        this.ghostDriver = ghostDriver;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogFile(File logFile) {
        this.logFile = logFile;
    }

    public Map<String, Object> getProxy() {
        return this.proxy;
    }

    public void setProxy(Map<String, Object> proxy) {
        this.proxy = proxy;
    }

    public String[] getCommandLineArguments() {
        return this.commandLineArguments;
    }

    public void setCommandLineArguments(String[] commandLineArguments) {
        this.commandLineArguments = commandLineArguments;
    }

    public String[] getGhostDriverCommandLineArguments() {
        return this.ghostDriverCommandLineArguments;
    }

    public void setGhostDriverCommandLineArguments(String[] ghostDriverCommandLineArguments) {
        this.ghostDriverCommandLineArguments = ghostDriverCommandLineArguments;
    }

    @Override
    public DriverService createDriverService() {
        PhantomJSDriverService.Builder builder = new PhantomJSDriverService.Builder();
        if (this.driverExecutable != null) {
            builder.usingPhantomJSExecutable(this.driverExecutable);
        }
        if (this.ghostDriver != null) {
            builder.usingGhostDriver(this.ghostDriver);
        }
        if (this.port != null) {
            builder.usingPort(this.port.intValue());
        }
        if (this.environment != null) {
            builder.withEnvironment(this.environment);
        }
        if (this.logFile != null) {
            builder.withLogFile(this.logFile);
        }
        if (this.proxy != null) {
            builder.withProxy(new Proxy(this.proxy));
        }
        if (this.commandLineArguments != null) {
            builder.usingCommandLineArguments(this.commandLineArguments);
        }
        if (this.ghostDriverCommandLineArguments != null) {
            builder.usingGhostDriverCommandLineArguments(this.ghostDriverCommandLineArguments);
        }
        return builder.build();
    }
}

