/*
 * Decompiled with CFR 0.152.
 */
package minium.developer.fs.service;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import minium.developer.fs.domain.AutoFormatter;
import minium.developer.fs.domain.FileContent;
import minium.developer.fs.domain.FileDTO;
import minium.developer.fs.domain.FileProps;
import minium.developer.fs.web.rest.IllegalOperationException;
import minium.developer.fs.web.rest.ResourceConflictException;
import minium.developer.fs.web.rest.ResourceNotFoundException;
import minium.internal.Throwables;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriComponentsBuilder;

public class FileSystemService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemService.class);
    @Autowired(required=false)
    private List<AutoFormatter> autoFormatters = Lists.newArrayList();
    private File baseDir = new File("src/test/resources");

    public FileSystemService() {
    }

    public FileSystemService(File baseDir) {
        this.baseDir = baseDir;
    }

    public FileProps getFileProps(String baseUrl, String path) throws IOException {
        File file = this.getFile(path);
        if (!file.exists()) {
            throw new ResourceNotFoundException();
        }
        return this.extractFileProps(baseUrl, file);
    }

    public Set<FileProps> list(String baseUrl, String path) throws IOException {
        File file = this.getFile(path);
        if (!file.exists()) {
            throw new ResourceNotFoundException("File " + file.getAbsolutePath() + " not found");
        }
        if (!file.isDirectory()) {
            new IllegalOperationException();
        }
        File[] childFiles = file.listFiles();
        HashSet fileProps = Sets.newHashSet();
        if (childFiles != null) {
            for (File childFile : childFiles) {
                fileProps.add(this.extractFileProps(baseUrl, childFile));
            }
        }
        return fileProps;
    }

    public Set<FileProps> listAll(String baseUrl, String path) throws IOException {
        String property = System.getProperty("user.home");
        File file = new File(property, path);
        if (!file.exists()) {
            throw new ResourceNotFoundException("File " + file.getAbsolutePath() + " not found");
        }
        if (!file.isDirectory()) {
            new IllegalOperationException();
        }
        File[] childFiles = file.listFiles();
        HashSet fileProps = Sets.newHashSet();
        if (childFiles != null) {
            for (File childFile : childFiles) {
                if (!childFile.isDirectory() || !childFile.exists() || childFile.isHidden()) continue;
                fileProps.add(this.extractFileProps2(baseUrl, childFile));
            }
        }
        return fileProps;
    }

    public FileContent getFileContent(String baseUrl, String path) throws IOException, URISyntaxException {
        FileSystemResource resource = this.get(path);
        File file = resource.getFile();
        return this.extractFileContent(baseUrl, file);
    }

    public FileProps create(String baseUrl, @RequestBody String path) throws IOException, URISyntaxException {
        File file = this.getFile(path);
        if (file.exists()) {
            return null;
        }
        file.createNewFile();
        LOGGER.info("Created new file {}", (Object)path);
        return this.extractFileProps(baseUrl, file);
    }

    public FileProps createFolder(String baseUrl, @RequestBody String path) throws IOException, URISyntaxException {
        File theDir = this.getFile(path);
        FileProps props = null;
        if (!theDir.exists()) {
            boolean result = false;
            try {
                theDir.mkdir();
                result = true;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (result) {
                LOGGER.info("Created new fodler {}", (Object)path);
                props = this.extractFileProps(baseUrl, theDir);
            }
        }
        return props;
    }

    public void delete(String path) throws IOException {
        File file = this.getFile(path);
        if (!file.exists()) {
            throw new ResourceNotFoundException();
        }
        if (!file.delete()) {
            new IllegalOperationException();
        }
    }

    public void deleteDirectory(String path) throws IOException {
        File directory = this.getFile(path);
        if (!directory.exists()) {
            throw new ResourceNotFoundException();
        }
        if (!directory.delete()) {
            new IllegalOperationException();
        }
        try {
            this.recursiveDelete(directory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FileProps renameFile(String baseUrl, FileDTO fileDTO) throws IOException {
        File file = this.getFile(fileDTO.getOldName());
        File newFile = new File(this.baseDir, fileDTO.getNewName());
        FileProps props = null;
        if (!file.exists()) {
            throw new ResourceNotFoundException();
        }
        boolean success = file.renameTo(newFile);
        if (success) {
            props = this.extractFileProps(baseUrl, newFile);
        }
        return props;
    }

    public FileContent save(String baseUrl, @RequestBody FileContent fileContent) throws IOException {
        FileProps fileProps = fileContent.getFileProps();
        File file = this.getFile(fileProps.getRelativeUri().getPath());
        if (!file.exists()) {
            throw new ResourceNotFoundException();
        }
        if (file.lastModified() != fileProps.getLastModified().getTime()) {
            throw new ResourceConflictException();
        }
        this.maybeAutoFormat(fileContent);
        FileUtils.write((File)file, (CharSequence)fileContent.getContent(), (Charset)Charsets.UTF_8);
        return this.extractFileContent(baseUrl, file);
    }

    public Set<FileProps> search(String baseUrl, String path, @RequestParam(value="q") String query) throws IOException {
        File file = this.getFile(path.endsWith("/") ? path.substring(0, path.length() - 1) : path);
        String antQuery = String.format("file://%s/**/*", file.getAbsolutePath());
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver((ResourceLoader)new FileSystemResourceLoader());
        Resource[] allResources = resolver.getResources(antQuery);
        String charWildcards = query.replaceAll("\\W", "").replaceAll("(\\w)(?=\\w)", "$1.*");
        Pattern pattern = Pattern.compile(String.format(".*%s.*", charWildcards), 2);
        HashSet fileProps = Sets.newHashSet();
        for (Resource resource : allResources) {
            FileProps fileProp;
            File matchedFile = resource.getFile();
            if (!matchedFile.isFile() || !pattern.matcher((fileProp = this.extractFileProps(baseUrl, resource.getFile())).getRelativeUri().toString()).matches()) continue;
            fileProps.add(fileProp);
        }
        return fileProps;
    }

    public boolean dirExists(String path) {
        boolean dirExists = false;
        File f = new File(path);
        if (f.exists() && f.isDirectory()) {
            dirExists = true;
        }
        return dirExists;
    }

    protected void maybeAutoFormat(FileContent fileContent) {
        for (AutoFormatter autoFormatter : this.autoFormatters) {
            if (!autoFormatter.handles(fileContent)) continue;
            autoFormatter.format(fileContent);
        }
    }

    public FileSystemResource get(String path) throws IOException, URISyntaxException {
        File file = this.getFile(path);
        if (!file.exists()) {
            throw new ResourceNotFoundException("File " + file.getAbsolutePath() + " not found");
        }
        if (file.isDirectory()) {
            return null;
        }
        return new FileSystemResource(file);
    }

    protected FileContent extractFileContent(String baseUrl, File file) throws IOException {
        FileProps props = this.extractFileProps(baseUrl, file);
        String content = FileUtils.readFileToString((File)file, (Charset)Charsets.UTF_8);
        return new FileContent(props, content);
    }

    protected File getFile(String path) throws IOException {
        return new File(this.baseDir, path);
    }

    protected FileProps extractFileProps(String baseUrl, File file) throws IOException {
        URI relativeUri = this.baseDir.toURI().relativize(file.toURI());
        String path = relativeUri.getPath();
        FileProps fileProps = new FileProps();
        fileProps.setName(file.getName());
        URI uri = UriComponentsBuilder.fromHttpUrl((String)baseUrl).path("fs/").path(path.toString()).build().toUri();
        fileProps.setUri(uri);
        fileProps.setRelativeUri(relativeUri);
        fileProps.setSize(FileUtils.sizeOf((File)file));
        fileProps.setType(file.isFile() ? FileProps.Type.FILE : FileProps.Type.DIR);
        fileProps.setLastModified(new Date(file.lastModified()));
        return fileProps;
    }

    protected FileProps extractFileProps2(String baseUrl, File file) throws IOException {
        File homeDir = new File(System.getProperty("user.home"));
        URI relativeUri = homeDir.toURI().relativize(file.toURI());
        String path = relativeUri.getPath();
        FileProps fileProps = new FileProps();
        fileProps.setName(file.getName());
        URI uri = UriComponentsBuilder.fromHttpUrl((String)baseUrl).path("fs/").path(path.toString()).build().toUri();
        fileProps.setAbsoluteUri(file.getAbsolutePath());
        fileProps.setUri(uri);
        fileProps.setRelativeUri(relativeUri);
        fileProps.setType(file.isFile() ? FileProps.Type.FILE : FileProps.Type.DIR);
        fileProps.setLastModified(new Date(file.lastModified()));
        return fileProps;
    }

    public void recursiveDelete(File file) throws IOException {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
                LOGGER.info("Directory is deleted : " + file.getAbsolutePath());
            } else {
                String[] files;
                for (String temp : files = file.list()) {
                    File fileDelete = new File(file, temp);
                    this.recursiveDelete(fileDelete);
                }
                if (file.list().length == 0) {
                    file.delete();
                    LOGGER.info("Directory is deleted : " + file.getAbsolutePath());
                }
            }
        } else {
            file.delete();
            LOGGER.info("File is deleted : " + file.getAbsolutePath());
        }
    }

    public Set<FileProps> searchContent(String baseUrl, String query) throws IOException {
        HashSet fileProps = Sets.newHashSet();
        if ("".equals(query) || query.length() <= 3) {
            return fileProps;
        }
        File file = this.getFile("steps");
        String antQuery = String.format("file://%s/**/*", file.getAbsolutePath());
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver((ResourceLoader)new FileSystemResourceLoader());
        Resource[] allResources = resolver.getResources(antQuery);
        String charWildcards = query.replaceAll("\\W", "").replaceAll("(\\w)(?=\\w)", "$1.*");
        Pattern pattern = Pattern.compile(String.format(".*%s.*", charWildcards), 2);
        for (Resource resource : allResources) {
            File matchedFile = resource.getFile();
            if (!matchedFile.isFile()) continue;
            FileProps fileProp = this.extractFileProps(baseUrl, resource.getFile());
            try {
                String line;
                FileReader fileReader = new FileReader(matchedFile);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                int lineNo = 1;
                while ((line = bufferedReader.readLine()) != null) {
                    if (pattern.matcher(line).matches()) {
                        fileProp.setLineNo(lineNo);
                        fileProps.add(fileProp);
                    }
                    ++lineNo;
                }
                fileReader.close();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return fileProps;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }
}

