/*
 * Decompiled with CFR 0.152.
 */
package minium.web.config.services;

import java.io.IOException;
import minium.internal.Throwables;
import org.openqa.selenium.remote.service.DriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public abstract class DriverServiceProperties
implements DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DriverServiceProperties.class);
    private DriverService driverService;
    private boolean wasRunning;

    public final DriverService getDriverService() {
        try {
            if (this.driverService == null) {
                this.driverService = this.createDriverService();
                this.wasRunning = this.driverService.isRunning();
                if (this.wasRunning) {
                    LOGGER.info("Driver service {} is already running", (Object)this.driverService.getUrl());
                } else {
                    this.driverService.start();
                    LOGGER.info("Driver service {} started", (Object)this.driverService.getUrl());
                }
            }
            return this.driverService;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected abstract DriverService createDriverService();

    public void destroy() throws Exception {
        if (this.driverService != null) {
            if (this.wasRunning) {
                LOGGER.info("Driver service {} was already running, so we don't stop it", (Object)this.driverService.getUrl());
            } else {
                this.driverService.stop();
                LOGGER.info("Driver service {} stopped", (Object)this.driverService.getUrl());
            }
        }
    }
}

