/*
 * Decompiled with CFR 0.152.
 */
package minium.actions.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import minium.actions.Configuration;
import minium.actions.Duration;
import minium.actions.ExceptionHandler;
import minium.actions.InteractionListener;
import platypus.Mixin;

public class DefaultConfiguration
extends Mixin.Impl
implements Configuration {
    private Duration defaultTimeout = new Duration(5L, TimeUnit.SECONDS);
    private Duration defaultInterval = new Duration(1L, TimeUnit.SECONDS);
    private final Map<String, Duration> timeoutPresets = Maps.newHashMap();
    private final Map<String, Duration> intervalPresets = Maps.newHashMap();
    private final Configuration.InteractionListenerCollection interactionListeners = new DefaultInteractionListenerCollection();
    private final Configuration.ExceptionHandlerCollection exceptionHandlers = new DefaultExceptionHandlerCollection();

    public DefaultConfiguration() {
        this.waitingPreset("immediate").timeout(0L, TimeUnit.SECONDS);
    }

    @Override
    public Duration defaultTimeout() {
        return this.defaultTimeout;
    }

    @Override
    public Configuration defaultTimeout(Duration defaultTimeout) {
        Preconditions.checkNotNull((Object)defaultTimeout);
        this.defaultTimeout = defaultTimeout;
        return this;
    }

    @Override
    public Configuration defaultTimeout(long time, TimeUnit unit) {
        return this.defaultTimeout(new Duration(time, unit));
    }

    @Override
    public Duration defaultInterval() {
        return this.defaultInterval;
    }

    @Override
    public Configuration defaultInterval(Duration defaultInterval) {
        Preconditions.checkNotNull((Object)defaultInterval);
        this.defaultInterval = defaultInterval;
        return this;
    }

    @Override
    public Configuration defaultInterval(long time, TimeUnit unit) {
        return this.defaultInterval(new Duration(time, unit));
    }

    @Override
    public Configuration.WaitingPreset waitingPreset(String preset) {
        return new DefaultWaitingPreset(preset);
    }

    @Override
    public Configuration.InteractionListenerCollection interactionListeners() {
        return this.interactionListeners;
    }

    @Override
    public Configuration.ExceptionHandlerCollection exceptionHandlers() {
        return this.exceptionHandlers;
    }

    private class DefaultExceptionHandlerCollection
    implements Configuration.ExceptionHandlerCollection {
        private Set<ExceptionHandler> exceptionHandlers = Sets.newLinkedHashSet();

        private DefaultExceptionHandlerCollection() {
        }

        @Override
        public Iterator<ExceptionHandler> iterator() {
            return Iterators.unmodifiableIterator(this.exceptionHandlers.iterator());
        }

        @Override
        public Configuration.ExceptionHandlerCollection add(ExceptionHandler exceptionHandler) {
            this.exceptionHandlers.add(exceptionHandler);
            return this;
        }

        @Override
        public Configuration.ExceptionHandlerCollection remove(ExceptionHandler exceptionHandler) {
            this.exceptionHandlers.remove(exceptionHandler);
            return this;
        }

        @Override
        public Configuration.ExceptionHandlerCollection clear() {
            this.exceptionHandlers.clear();
            return this;
        }

        @Override
        public Configuration done() {
            return DefaultConfiguration.this;
        }
    }

    private class DefaultInteractionListenerCollection
    implements Configuration.InteractionListenerCollection {
        private Set<InteractionListener> interactionListeners = Sets.newLinkedHashSet();

        private DefaultInteractionListenerCollection() {
        }

        @Override
        public Iterator<InteractionListener> iterator() {
            return Iterators.unmodifiableIterator(this.interactionListeners.iterator());
        }

        @Override
        public Configuration.InteractionListenerCollection add(InteractionListener interactionListener) {
            this.interactionListeners.add(interactionListener);
            return this;
        }

        @Override
        public Configuration.InteractionListenerCollection remove(InteractionListener interactionListener) {
            this.interactionListeners.remove(interactionListener);
            return this;
        }

        @Override
        public Configuration.InteractionListenerCollection clear() {
            this.interactionListeners.clear();
            return this;
        }

        @Override
        public Configuration done() {
            return DefaultConfiguration.this;
        }
    }

    private class DefaultWaitingPreset
    implements Configuration.WaitingPreset {
        private final String preset;

        public DefaultWaitingPreset(String preset) {
            this.preset = preset;
        }

        @Override
        public Configuration.WaitingPreset timeout(Duration timeout) {
            DefaultConfiguration.this.timeoutPresets.put(this.preset, timeout);
            return this;
        }

        @Override
        public Configuration.WaitingPreset interval(Duration interval) {
            DefaultConfiguration.this.intervalPresets.put(this.preset, interval);
            return this;
        }

        @Override
        public Configuration.WaitingPreset timeout(long time, TimeUnit unit) {
            return this.timeout(new Duration(time, unit));
        }

        @Override
        public Configuration.WaitingPreset interval(long time, TimeUnit unit) {
            return this.interval(new Duration(time, unit));
        }

        @Override
        public Duration timeout() {
            Duration timeout = (Duration)DefaultConfiguration.this.timeoutPresets.get(this.preset);
            return timeout == null ? DefaultConfiguration.this.defaultTimeout() : timeout;
        }

        @Override
        public Duration interval() {
            Duration interval = (Duration)DefaultConfiguration.this.intervalPresets.get(this.preset);
            return interval == null ? DefaultConfiguration.this.defaultInterval() : interval;
        }

        @Override
        public Configuration.WaitingPreset reset() {
            DefaultConfiguration.this.timeoutPresets.remove(this.preset);
            DefaultConfiguration.this.intervalPresets.remove(this.preset);
            return this;
        }

        @Override
        public Configuration done() {
            return DefaultConfiguration.this;
        }
    }
}

