/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.report;

import com.fasterxml.jackson.annotation.JsonView;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import minium.cucumber.report.ScenarioResults;
import minium.cucumber.report.StepResults;
import minium.cucumber.report.domain.Element;
import minium.cucumber.report.domain.Feature;
import minium.cucumber.report.domain.Status;
import minium.cucumber.report.domain.Step;
import minium.cucumber.report.domain.Views;

public class FeatureResult {
    @JsonView(value={Views.Full.class})
    private StepResults stepResults;
    @JsonView(value={Views.Full.class})
    private ScenarioResults scenarioResults;
    @JsonView(value={Views.Public.class})
    private Feature feature;
    @JsonView(value={Views.Public.class})
    private String profile;

    public FeatureResult() {
    }

    public FeatureResult(Feature feature) {
        this.setFeature(feature);
        this.processSteps();
    }

    public FeatureResult(Feature feature, String profile) {
        this.setFeature(feature);
        this.setProfile(profile);
        this.processSteps();
    }

    public int getNumberOfSteps() {
        return this.stepResults.getNumberOfSteps();
    }

    public int getNumberOfPasses() {
        return this.stepResults.getNumberOfPasses();
    }

    public int getNumberOfFailures() {
        return this.stepResults.getNumberOfFailures();
    }

    public int getNumberOfPending() {
        return this.stepResults.getNumberOfPending();
    }

    public int getNumberOfSkipped() {
        return this.stepResults.getNumberOfSkipped();
    }

    public int getNumberOfMissing() {
        return this.stepResults.getNumberOfMissing();
    }

    public int getNumberOfUndefined() {
        return this.stepResults.getNumberOfUndefined();
    }

    public long getDurationOfSteps() {
        return this.stepResults.getTotalDuration();
    }

    public int getNumberOfScenariosPassed() {
        return this.scenarioResults.getNumberOfScenariosPassed();
    }

    public int getNumberOfScenariosFailed() {
        return this.scenarioResults.getNumberOfScenariosFailed();
    }

    public int getNumberOfTotalScenarios() {
        return this.scenarioResults.getNumberOfTotalScenarios();
    }

    public Feature getFeature() {
        return this.feature;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    protected void processSteps() {
        ArrayList allSteps = Lists.newArrayList();
        ArrayList passedSteps = Lists.newArrayList();
        ArrayList failedSteps = Lists.newArrayList();
        ArrayList skippedSteps = Lists.newArrayList();
        ArrayList undefinedSteps = Lists.newArrayList();
        ArrayList pendingSteps = Lists.newArrayList();
        ArrayList missingSteps = Lists.newArrayList();
        ArrayList allScenarios = Lists.newArrayList();
        ArrayList passedScenarios = Lists.newArrayList();
        ArrayList failedScenarios = Lists.newArrayList();
        Long totalDuration = 0L;
        for (Element element : this.feature.getElements()) {
            this.calculateScenarioStats(allScenarios, passedScenarios, failedScenarios, element);
            for (Step step : element.getSteps()) {
                allSteps.add(step);
                switch (step.getStatus()) {
                    case PASSED: {
                        passedSteps.add(step);
                        break;
                    }
                    case FAILED: {
                        failedSteps.add(step);
                        break;
                    }
                    case SKIPPED: {
                        skippedSteps.add(step);
                        break;
                    }
                    case UNDEFINED: {
                        undefinedSteps.add(step);
                        break;
                    }
                    case PENDING: {
                        pendingSteps.add(step);
                        break;
                    }
                    case MISSING: {
                        missingSteps.add(step);
                        break;
                    }
                }
                totalDuration = totalDuration + step.getDuration();
            }
        }
        this.scenarioResults = new ScenarioResults(allScenarios.size(), passedScenarios.size(), failedScenarios.size());
        this.stepResults = new StepResults(allSteps, passedSteps, failedSteps, skippedSteps, pendingSteps, missingSteps, undefinedSteps, totalDuration);
    }

    protected void calculateScenarioStats(List<Element> allScenarios, List<Element> passedScenarios, List<Element> failedScenarios, Element element) {
        if (Objects.equals(element.getType(), "scenario_outline")) {
            return;
        }
        if (!Objects.equals(element.getType(), "background")) {
            allScenarios.add(element);
            if (element.getStatus() == Status.PASSED) {
                passedScenarios.add(element);
            } else if (element.getStatus() == Status.FAILED) {
                failedScenarios.add(element);
            }
        }
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }
}

