/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.xstream;

import cucumber.deps.com.thoughtworks.xstream.converters.SingleValueConverter;
import java.util.ArrayList;
import java.util.List;

class ListConverter
implements SingleValueConverter {
    private final String delimiter;
    private final SingleValueConverter delegate;

    public ListConverter(String delimiter, SingleValueConverter delegate) {
        this.delimiter = delimiter;
        this.delegate = delegate;
    }

    public String toString(Object obj) {
        boolean first = true;
        if (obj instanceof List) {
            StringBuilder sb = new StringBuilder();
            for (Object elem : (List)obj) {
                if (!first) {
                    sb.append(this.delimiter);
                }
                sb.append(this.delegate.toString(elem));
                first = false;
            }
            return sb.toString();
        }
        return this.delegate.toString(obj);
    }

    public Object fromString(String s) {
        if (s.isEmpty()) {
            return new ArrayList(0);
        }
        String[] strings = s.split(this.delimiter);
        ArrayList<Object> list = new ArrayList<Object>(strings.length);
        for (String elem : strings) {
            list.add(this.delegate.fromString(elem));
        }
        return list;
    }

    public boolean canConvert(Class type) {
        return List.class.isAssignableFrom(type);
    }
}

