/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.SnippetType;
import cucumber.api.StepDefinitionReporter;
import cucumber.api.SummaryPrinter;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Env;
import cucumber.runtime.Shellwords;
import cucumber.runtime.Utils;
import cucumber.runtime.formatter.ColorAware;
import cucumber.runtime.formatter.PluginFactory;
import cucumber.runtime.formatter.StrictAware;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.PathWithLines;
import gherkin.I18n;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.util.FixJava;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;

public class RuntimeOptions {
    public static final String VERSION = ResourceBundle.getBundle("cucumber.version").getString("cucumber-jvm.version");
    public static final String USAGE_RESOURCE = "/cucumber/api/cli/USAGE.txt";
    static String usageText;
    private final List<String> glue = new ArrayList<String>();
    private final List<Object> filters = new ArrayList<Object>();
    private final List<String> featurePaths = new ArrayList<String>();
    private final List<String> pluginFormatterNames = new ArrayList<String>();
    private final List<String> pluginStepDefinitionReporterNames = new ArrayList<String>();
    private final List<String> pluginSummaryPrinterNames = new ArrayList<String>();
    private final List<String> junitOptions = new ArrayList<String>();
    private final PluginFactory pluginFactory;
    private final List<Object> plugins = new ArrayList<Object>();
    private boolean dryRun;
    private boolean strict = false;
    private boolean monochrome = false;
    private SnippetType snippetType = SnippetType.UNDERSCORE;
    private boolean pluginNamesInstantiated;

    public RuntimeOptions(String argv) {
        this(new PluginFactory(), Shellwords.parse(argv));
    }

    public RuntimeOptions(List<String> argv) {
        this(new PluginFactory(), argv);
    }

    public RuntimeOptions(Env env, List<String> argv) {
        this(env, new PluginFactory(), argv);
    }

    public RuntimeOptions(PluginFactory pluginFactory, List<String> argv) {
        this(Env.INSTANCE, pluginFactory, argv);
    }

    public RuntimeOptions(Env env, PluginFactory pluginFactory, List<String> argv) {
        this.pluginFactory = pluginFactory;
        argv = new ArrayList<String>(argv);
        this.parse(argv);
        String cucumberOptionsFromEnv = env.get("cucumber.options");
        if (cucumberOptionsFromEnv != null) {
            this.parse(Shellwords.parse(cucumberOptionsFromEnv));
        }
        if (this.pluginFormatterNames.isEmpty()) {
            this.pluginFormatterNames.add("progress");
        }
        if (this.pluginSummaryPrinterNames.isEmpty()) {
            this.pluginSummaryPrinterNames.add("default_summary");
        }
    }

    private void parse(List<String> args) {
        ArrayList<Object> parsedFilters = new ArrayList<Object>();
        ArrayList<String> parsedFeaturePaths = new ArrayList<String>();
        ArrayList<String> parsedGlue = new ArrayList<String>();
        ParsedPluginData parsedPluginData = new ParsedPluginData();
        ArrayList<String> parsedJunitOptions = new ArrayList<String>();
        while (!args.isEmpty()) {
            String nextArg;
            String arg = args.remove(0).trim();
            if (arg.equals("--help") || arg.equals("-h")) {
                this.printUsage();
                System.exit(0);
                continue;
            }
            if (arg.equals("--version") || arg.equals("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (arg.equals("--i18n")) {
                nextArg = args.remove(0);
                System.exit(this.printI18n(nextArg));
                continue;
            }
            if (arg.equals("--glue") || arg.equals("-g")) {
                String gluePath = args.remove(0);
                parsedGlue.add(gluePath);
                continue;
            }
            if (arg.equals("--tags") || arg.equals("-t")) {
                parsedFilters.add(args.remove(0));
                continue;
            }
            if (arg.equals("--plugin") || arg.equals("--add-plugin") || arg.equals("-p")) {
                parsedPluginData.addPluginName(args.remove(0), arg.equals("--add-plugin"));
                continue;
            }
            if (arg.equals("--format") || arg.equals("-f")) {
                System.err.println("WARNING: Cucumber-JVM's --format option is deprecated. Please use --plugin instead.");
                parsedPluginData.addPluginName(args.remove(0), true);
                continue;
            }
            if (arg.equals("--no-dry-run") || arg.equals("--dry-run") || arg.equals("-d")) {
                this.dryRun = !arg.startsWith("--no-");
                continue;
            }
            if (arg.equals("--no-strict") || arg.equals("--strict") || arg.equals("-s")) {
                this.strict = !arg.startsWith("--no-");
                continue;
            }
            if (arg.equals("--no-monochrome") || arg.equals("--monochrome") || arg.equals("-m")) {
                this.monochrome = !arg.startsWith("--no-");
                continue;
            }
            if (arg.equals("--snippets")) {
                nextArg = args.remove(0);
                this.snippetType = SnippetType.fromString(nextArg);
                continue;
            }
            if (arg.equals("--name") || arg.equals("-n")) {
                nextArg = args.remove(0);
                Pattern patternFilter = Pattern.compile(nextArg);
                parsedFilters.add(patternFilter);
                continue;
            }
            if (arg.startsWith("--junit,")) {
                for (String option : arg.substring("--junit,".length()).split(",")) {
                    parsedJunitOptions.add(option);
                }
                continue;
            }
            if (arg.startsWith("-")) {
                this.printUsage();
                throw new CucumberException("Unknown option: " + arg);
            }
            parsedFeaturePaths.add(arg);
        }
        if (!parsedFilters.isEmpty() || this.haveLineFilters(parsedFeaturePaths)) {
            this.filters.clear();
            this.filters.addAll(parsedFilters);
            if (parsedFeaturePaths.isEmpty() && !this.featurePaths.isEmpty()) {
                this.stripLinesFromFeaturePaths(this.featurePaths);
            }
        }
        if (!parsedFeaturePaths.isEmpty()) {
            this.featurePaths.clear();
            this.featurePaths.addAll(parsedFeaturePaths);
        }
        if (!parsedGlue.isEmpty()) {
            this.glue.clear();
            this.glue.addAll(parsedGlue);
        }
        if (!parsedJunitOptions.isEmpty()) {
            this.junitOptions.clear();
            this.junitOptions.addAll(parsedJunitOptions);
        }
        parsedPluginData.updatePluginFormatterNames(this.pluginFormatterNames);
        parsedPluginData.updatePluginStepDefinitionReporterNames(this.pluginStepDefinitionReporterNames);
        parsedPluginData.updatePluginSummaryPrinterNames(this.pluginSummaryPrinterNames);
    }

    private boolean haveLineFilters(List<String> parsedFeaturePaths) {
        for (String pathName : parsedFeaturePaths) {
            if (!pathName.startsWith("@") && !PathWithLines.hasLineFilters(pathName)) continue;
            return true;
        }
        return false;
    }

    private void stripLinesFromFeaturePaths(List<String> featurePaths) {
        ArrayList<String> newPaths = new ArrayList<String>();
        for (String pathName : featurePaths) {
            newPaths.add(PathWithLines.stripLineFilters(pathName));
        }
        featurePaths.clear();
        featurePaths.addAll(newPaths);
    }

    private void printUsage() {
        RuntimeOptions.loadUsageTextIfNeeded();
        System.out.println(usageText);
    }

    static void loadUsageTextIfNeeded() {
        if (usageText == null) {
            try {
                InputStreamReader reader = new InputStreamReader(FixJava.class.getResourceAsStream(USAGE_RESOURCE), "UTF-8");
                usageText = FixJava.readReader((Reader)reader);
            }
            catch (Exception e) {
                usageText = "Could not load usage text: " + e.toString();
            }
        }
    }

    private int printI18n(String language) {
        List all = I18n.getAll();
        if (language.equalsIgnoreCase("help")) {
            for (I18n i18n : all) {
                System.out.println(i18n.getIsoCode());
            }
            return 0;
        }
        return this.printKeywordsFor(language, all);
    }

    private int printKeywordsFor(String language, List<I18n> all) {
        for (I18n i18n : all) {
            if (!i18n.getIsoCode().equalsIgnoreCase(language)) continue;
            System.out.println(i18n.getKeywordTable());
            return 0;
        }
        System.err.println("Unrecognised ISO language code");
        return 1;
    }

    public List<CucumberFeature> cucumberFeatures(ResourceLoader resourceLoader) {
        return CucumberFeature.load(resourceLoader, this.featurePaths, this.filters, System.out);
    }

    List<Object> getPlugins() {
        if (!this.pluginNamesInstantiated) {
            Object plugin;
            for (String pluginName : this.pluginFormatterNames) {
                plugin = this.pluginFactory.create(pluginName);
                this.plugins.add(plugin);
                this.setMonochromeOnColorAwarePlugins(plugin);
                this.setStrictOnStrictAwarePlugins(plugin);
            }
            for (String pluginName : this.pluginStepDefinitionReporterNames) {
                plugin = this.pluginFactory.create(pluginName);
                this.plugins.add(plugin);
            }
            for (String pluginName : this.pluginSummaryPrinterNames) {
                plugin = this.pluginFactory.create(pluginName);
                this.plugins.add(plugin);
            }
            this.pluginNamesInstantiated = true;
        }
        return this.plugins;
    }

    public Formatter formatter(ClassLoader classLoader) {
        return this.pluginProxy(classLoader, Formatter.class);
    }

    public Reporter reporter(ClassLoader classLoader) {
        return this.pluginProxy(classLoader, Reporter.class);
    }

    public StepDefinitionReporter stepDefinitionReporter(ClassLoader classLoader) {
        return this.pluginProxy(classLoader, StepDefinitionReporter.class);
    }

    public SummaryPrinter summaryPrinter(ClassLoader classLoader) {
        return this.pluginProxy(classLoader, SummaryPrinter.class);
    }

    public <T> T pluginProxy(ClassLoader classLoader, final Class<T> type) {
        Object proxy = Proxy.newProxyInstance(classLoader, new Class[]{type}, new InvocationHandler(){

            @Override
            public Object invoke(Object target, Method method, Object[] args) throws Throwable {
                for (Object plugin : RuntimeOptions.this.getPlugins()) {
                    if (!type.isInstance(plugin)) continue;
                    try {
                        Utils.invoke(plugin, method, 0L, args);
                    }
                    catch (Throwable t) {
                        if (method.getName().equals("startOfScenarioLifeCycle") || method.getName().equals("endOfScenarioLifeCycle")) continue;
                        throw t;
                    }
                }
                return null;
            }
        });
        return type.cast(proxy);
    }

    private void setMonochromeOnColorAwarePlugins(Object plugin) {
        if (plugin instanceof ColorAware) {
            ColorAware colorAware = (ColorAware)plugin;
            colorAware.setMonochrome(this.monochrome);
        }
    }

    private void setStrictOnStrictAwarePlugins(Object plugin) {
        if (plugin instanceof StrictAware) {
            StrictAware strictAware = (StrictAware)plugin;
            strictAware.setStrict(this.strict);
        }
    }

    public List<String> getGlue() {
        return this.glue;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public List<String> getFeaturePaths() {
        return this.featurePaths;
    }

    public void addPlugin(Object plugin) {
        this.plugins.add(plugin);
    }

    public List<Object> getFilters() {
        return this.filters;
    }

    public boolean isMonochrome() {
        return this.monochrome;
    }

    public SnippetType getSnippetType() {
        return this.snippetType;
    }

    public List<String> getJunitOptions() {
        return this.junitOptions;
    }

    class ParsedOptionNames {
        private List<String> names = new ArrayList<String>();
        private boolean clobber = false;

        ParsedOptionNames() {
        }

        public void addName(String name, boolean isAddOption) {
            this.names.add(name);
            if (!isAddOption) {
                this.clobber = true;
            }
        }

        public void updateNameList(List<String> nameList) {
            if (!this.names.isEmpty()) {
                if (this.clobber) {
                    nameList.clear();
                }
                nameList.addAll(this.names);
            }
        }
    }

    class ParsedPluginData {
        ParsedOptionNames formatterNames;
        ParsedOptionNames stepDefinitionReporterNames;
        ParsedOptionNames summaryPrinterNames;

        ParsedPluginData() {
            this.formatterNames = new ParsedOptionNames();
            this.stepDefinitionReporterNames = new ParsedOptionNames();
            this.summaryPrinterNames = new ParsedOptionNames();
        }

        public void addPluginName(String name, boolean isAddPlugin) {
            if (PluginFactory.isFormatterName(name)) {
                this.formatterNames.addName(name, isAddPlugin);
            } else if (PluginFactory.isStepDefinitionResporterName(name)) {
                this.stepDefinitionReporterNames.addName(name, isAddPlugin);
            } else if (PluginFactory.isSummaryPrinterName(name)) {
                this.summaryPrinterNames.addName(name, isAddPlugin);
            } else {
                throw new CucumberException("Unrecognized plugin: " + name);
            }
        }

        public void updatePluginFormatterNames(List<String> pluginFormatterNames) {
            this.formatterNames.updateNameList(pluginFormatterNames);
        }

        public void updatePluginStepDefinitionReporterNames(List<String> pluginStepDefinitionReporterNames) {
            this.stepDefinitionReporterNames.updateNameList(pluginStepDefinitionReporterNames);
        }

        public void updatePluginSummaryPrinterNames(List<String> pluginSummaryPrinterNames) {
            this.summaryPrinterNames.updateNameList(pluginSummaryPrinterNames);
        }
    }
}

