/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.actions;

import java.util.concurrent.TimeUnit;
import minium.Elements;
import minium.actions.AsyncInteraction;
import minium.web.internal.actions.AbstractWebInteraction;
import org.openqa.selenium.support.ui.Duration;
import org.openqa.selenium.support.ui.Sleeper;

public abstract class AsyncTimeElapsedInteraction
extends AbstractWebInteraction
implements AsyncInteraction {
    protected minium.actions.Duration duration;
    private long start = -1L;

    public AsyncTimeElapsedInteraction(Elements elems, minium.actions.Duration duration) {
        super(elems);
        this.duration = duration;
    }

    protected void doPerform() {
        this.start = System.currentTimeMillis();
    }

    public boolean isComplete() {
        return this.start < 0L;
    }

    public void waitUntilCompleted() {
        try {
            long end = TimeUnit.MILLISECONDS.convert(this.duration.getTime(), this.duration.getUnit());
            long time = this.start + end - System.currentTimeMillis();
            if (time > 0L) {
                Sleeper.SYSTEM_SLEEPER.sleep(new Duration(time, TimeUnit.MILLISECONDS));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        finally {
            this.start = -1L;
        }
    }
}

