/*
 * Decompiled with CFR 0.152.
 */
package minium.actions.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import minium.Elements;
import minium.actions.HasInteractionListeners;
import minium.actions.Interactable;
import minium.actions.InteractionListener;
import minium.actions.internal.WaitingPresetInteractionListener;
import minium.internal.Chainable;
import minium.internal.HasParent;

public class DefaultHasInteractionListeners<T extends Interactable<?>>
extends Chainable<T>
implements HasInteractionListeners<T> {
    private Set<InteractionListener> listeners = Sets.newLinkedHashSet();

    @Override
    public T immediately() {
        return this.withWaitingPreset("immediate");
    }

    @Override
    public T withWaitingPreset(String waitingPreset) {
        return this.with((InteractionListener)new WaitingPresetInteractionListener(waitingPreset));
    }

    @Override
    public T with(InteractionListener listener) {
        return this.with(new InteractionListener[]{listener});
    }

    @Override
    public T with(InteractionListener ... listeners) {
        this.listeners.addAll(Arrays.asList(listeners));
        return (T)((Interactable)this.myself());
    }

    @Override
    public Set<InteractionListener> interactionListeners() {
        Elements parent;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.is(HasParent.class) && (parent = ((HasParent)this.as(HasParent.class)).parent()).is(HasInteractionListeners.class)) {
            builder.addAll(((HasInteractionListeners)parent.as(HasInteractionListeners.class)).interactionListeners());
        }
        return builder.addAll(this.listeners).build();
    }
}

