/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.el.ELException;
import javax.el.MethodNotFoundException;
import org.apache.el.lang.ELSupport;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.util.MessageFactory;

public class ReflectionUtil {
    protected static final String[] PRIMITIVE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    protected static final Class<?>[] PRIMITIVES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};

    private ReflectionUtil() {
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        if (null == name || "".equals(name)) {
            return null;
        }
        Class<?> c = ReflectionUtil.forNamePrimitive(name);
        if (c == null) {
            if (name.endsWith("[]")) {
                String nc = name.substring(0, name.length() - 2);
                c = Class.forName(nc, true, Thread.currentThread().getContextClassLoader());
                c = Array.newInstance(c, 0).getClass();
            } else {
                c = Class.forName(name, true, Thread.currentThread().getContextClassLoader());
            }
        }
        return c;
    }

    protected static Class<?> forNamePrimitive(String name) {
        int p;
        if (name.length() <= 8 && (p = Arrays.binarySearch(PRIMITIVE_NAMES, name)) >= 0) {
            return PRIMITIVES[p];
        }
        return null;
    }

    public static Class<?>[] toTypeArray(String[] s) throws ClassNotFoundException {
        if (s == null) {
            return null;
        }
        Class[] c = new Class[s.length];
        for (int i = 0; i < s.length; ++i) {
            c[i] = ReflectionUtil.forName(s[i]);
        }
        return c;
    }

    public static String[] toTypeNameArray(Class<?>[] c) {
        if (c == null) {
            return null;
        }
        String[] s = new String[c.length];
        for (int i = 0; i < c.length; ++i) {
            s[i] = c[i].getName();
        }
        return s;
    }

    public static Method getMethod(EvaluationContext ctx, Object base, Object property, Class<?>[] paramTypes, Object[] paramValues) throws MethodNotFoundException {
        if (base == null || property == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", base, property, ReflectionUtil.paramString(paramTypes)));
        }
        String methodName = property instanceof String ? (String)property : property.toString();
        int paramCount = paramTypes == null ? 0 : paramTypes.length;
        Method[] methods = base.getClass().getMethods();
        HashMap<Method, MatchResult> candidates = new HashMap<Method, MatchResult>();
        for (Method m : methods) {
            Class<?>[] mParamTypes;
            int mParamCount;
            if (!m.getName().equals(methodName) || paramCount != (mParamCount = (mParamTypes = m.getParameterTypes()) == null ? 0 : mParamTypes.length) && (!m.isVarArgs() || paramCount < mParamCount)) continue;
            int exactMatch = 0;
            int assignableMatch = 0;
            int coercibleMatch = 0;
            boolean noMatch = false;
            block1: for (int i = 0; i < mParamCount; ++i) {
                if (mParamTypes[i].equals(paramTypes[i])) {
                    ++exactMatch;
                    continue;
                }
                if (i == mParamCount - 1 && m.isVarArgs()) {
                    Class<?> varType = mParamTypes[i].getComponentType();
                    for (int j = i; j < paramCount; ++j) {
                        if (ReflectionUtil.isAssignableFrom(paramTypes[j], varType)) {
                            ++assignableMatch;
                            continue;
                        }
                        if (paramValues == null || j >= paramValues.length) {
                            noMatch = true;
                            continue block1;
                        }
                        if (ReflectionUtil.isCoercibleFrom(ctx, paramValues[j], varType)) {
                            ++coercibleMatch;
                            continue;
                        }
                        noMatch = true;
                        continue block1;
                    }
                    continue;
                }
                if (ReflectionUtil.isAssignableFrom(paramTypes[i], mParamTypes[i])) {
                    ++assignableMatch;
                    continue;
                }
                if (paramValues == null || i >= paramValues.length) {
                    noMatch = true;
                    break;
                }
                if (ReflectionUtil.isCoercibleFrom(ctx, paramValues[i], mParamTypes[i])) {
                    ++coercibleMatch;
                    continue;
                }
                noMatch = true;
                break;
            }
            if (noMatch) continue;
            if (exactMatch == paramCount) {
                return ReflectionUtil.getMethod(base.getClass(), m);
            }
            candidates.put(m, new MatchResult(exactMatch, assignableMatch, coercibleMatch, m.isBridge()));
        }
        MatchResult bestMatch = new MatchResult(0, 0, 0, false);
        Method match = null;
        boolean multiple = false;
        for (Map.Entry entry : candidates.entrySet()) {
            int cmp = ((MatchResult)entry.getValue()).compareTo(bestMatch);
            if (cmp > 0 || match == null) {
                bestMatch = (MatchResult)entry.getValue();
                match = (Method)entry.getKey();
                multiple = false;
                continue;
            }
            if (cmp != 0) continue;
            multiple = true;
        }
        if (multiple && (match = bestMatch.getExact() == paramCount - 1 ? ReflectionUtil.resolveAmbiguousMethod(candidates.keySet(), paramTypes) : null) == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.ambiguous", base, property, ReflectionUtil.paramString(paramTypes)));
        }
        if (match == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", base, property, ReflectionUtil.paramString(paramTypes)));
        }
        return ReflectionUtil.getMethod(base.getClass(), match);
    }

    /*
     * WARNING - void declaration
     */
    private static Method resolveAmbiguousMethod(Set<Method> candidates, Class<?>[] paramTypes) {
        void var6_14;
        Method m = candidates.iterator().next();
        int nonMatchIndex = 0;
        Class<?> nonMatchClass = null;
        for (int i = 0; i < paramTypes.length; ++i) {
            if (m.getParameterTypes()[i] == paramTypes[i]) continue;
            nonMatchIndex = i;
            nonMatchClass = paramTypes[i];
            break;
        }
        if (nonMatchClass == null) {
            return null;
        }
        for (Method method : candidates) {
            if (method.getParameterTypes()[nonMatchIndex] != paramTypes[nonMatchIndex]) continue;
            return null;
        }
        for (Class superClass = nonMatchClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            for (Method c : candidates) {
                if (!c.getParameterTypes()[nonMatchIndex].equals(superClass)) continue;
                return c;
            }
        }
        Object var6_10 = null;
        if (Number.class.isAssignableFrom(nonMatchClass)) {
            for (Method c : candidates) {
                void var6_11;
                Class<?> candidateType = c.getParameterTypes()[nonMatchIndex];
                if (!Number.class.isAssignableFrom(candidateType) && !candidateType.isPrimitive()) continue;
                if (var6_11 == null) {
                    Method method = c;
                    continue;
                }
                Object var6_13 = null;
                break;
            }
        }
        return var6_14;
    }

    private static boolean isAssignableFrom(Class<?> src, Class<?> target) {
        if (src == null) {
            return true;
        }
        Class<Object> targetClass = target.isPrimitive() ? (target == Boolean.TYPE ? Boolean.class : (target == Character.TYPE ? Character.class : (target == Byte.TYPE ? Byte.class : (target == Short.TYPE ? Short.class : (target == Integer.TYPE ? Integer.class : (target == Long.TYPE ? Long.class : (target == Float.TYPE ? Float.class : Double.class))))))) : target;
        return targetClass.isAssignableFrom(src);
    }

    private static boolean isCoercibleFrom(EvaluationContext ctx, Object src, Class<?> target) {
        try {
            ELSupport.coerceToType(ctx, src, target);
        }
        catch (ELException e) {
            return false;
        }
        return true;
    }

    private static Method getMethod(Class<?> type, Method m) {
        if (m == null || Modifier.isPublic(type.getModifiers())) {
            return m;
        }
        Class<?>[] inf = type.getInterfaces();
        Method mp = null;
        for (int i = 0; i < inf.length; ++i) {
            try {
                mp = inf[i].getMethod(m.getName(), m.getParameterTypes());
                mp = ReflectionUtil.getMethod(mp.getDeclaringClass(), mp);
                if (mp == null) continue;
                return mp;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Class<?> sup = type.getSuperclass();
        if (sup != null) {
            try {
                mp = sup.getMethod(m.getName(), m.getParameterTypes());
                mp = ReflectionUtil.getMethod(mp.getDeclaringClass(), mp);
                if (mp != null) {
                    return mp;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    private static final String paramString(Class<?>[] types) {
        if (types != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] == null) {
                    sb.append("null, ");
                    continue;
                }
                sb.append(types[i].getName()).append(", ");
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
            }
            return sb.toString();
        }
        return null;
    }

    private static class MatchResult
    implements Comparable<MatchResult> {
        private final int exact;
        private final int assignable;
        private final int coercible;
        private final boolean bridge;

        public MatchResult(int exact, int assignable, int coercible, boolean bridge) {
            this.exact = exact;
            this.assignable = assignable;
            this.coercible = coercible;
            this.bridge = bridge;
        }

        public int getExact() {
            return this.exact;
        }

        public int getAssignable() {
            return this.assignable;
        }

        public int getCoercible() {
            return this.coercible;
        }

        public boolean isBridge() {
            return this.bridge;
        }

        @Override
        public int compareTo(MatchResult o) {
            int cmp = Integer.compare(this.getExact(), o.getExact());
            if (cmp == 0 && (cmp = Integer.compare(this.getAssignable(), o.getAssignable())) == 0 && (cmp = Integer.compare(this.getCoercible(), o.getCoercible())) == 0) {
                cmp = Boolean.compare(o.isBridge(), this.isBridge());
            }
            return cmp;
        }
    }
}

