/*
 * Decompiled with CFR 0.152.
 */
package minium.web.config.services;

import java.io.File;
import java.util.Map;
import minium.web.config.services.DriverServiceProperties;
import org.openqa.selenium.ie.InternetExplorerDriverEngine;
import org.openqa.selenium.ie.InternetExplorerDriverLogLevel;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.remote.service.DriverService;

public class InternetExplorerDriverServiceProperties
extends DriverServiceProperties {
    private File driverExecutable;
    private Integer port;
    private Map<String, String> environment;
    private File logFile;
    private String logLevel;
    private String engineImplementation;
    private String host;
    private File extractPath;
    private Boolean silent;

    public File getDriverExecutable() {
        return this.driverExecutable;
    }

    public void setDriverExecutable(File driverExecutable) {
        this.driverExecutable = driverExecutable;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogFile(File logFile) {
        this.logFile = logFile;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getEngineImplementation() {
        return this.engineImplementation;
    }

    public void setEngineImplementation(String engineImplementation) {
        this.engineImplementation = engineImplementation;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public File getExtractPath() {
        return this.extractPath;
    }

    public void setExtractPath(File extractPath) {
        this.extractPath = extractPath;
    }

    public Boolean getSilent() {
        return this.silent;
    }

    public void setSilent(Boolean silent) {
        this.silent = silent;
    }

    @Override
    public DriverService createDriverService() {
        InternetExplorerDriverService.Builder builder = new InternetExplorerDriverService.Builder();
        if (this.port != null) {
            builder.usingPort(this.port.intValue());
        }
        if (this.driverExecutable != null) {
            builder.usingDriverExecutable(this.driverExecutable);
        }
        if (this.environment != null) {
            builder.withEnvironment(this.environment);
        }
        if (this.logFile != null) {
            builder.withLogFile(this.logFile);
        }
        if (this.logLevel != null) {
            builder.withLogLevel(InternetExplorerDriverLogLevel.valueOf((String)this.logLevel.toUpperCase()));
        }
        if (this.engineImplementation != null) {
            builder.withEngineImplementation(InternetExplorerDriverEngine.valueOf((String)this.engineImplementation.toUpperCase()));
        }
        if (this.host != null) {
            builder.withHost(this.host);
        }
        if (this.extractPath != null) {
            builder.withExtractPath(this.extractPath);
        }
        if (this.silent != null) {
            builder.withSilent(this.silent);
        }
        return builder.build();
    }
}

