/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal;

import com.google.common.base.Defaults;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.reflect.AbstractInvocationHandler;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashSet;
import minium.BasicElements;
import minium.Elements;
import minium.internal.ElementsFactory;
import minium.internal.InternalElementsFactory;
import minium.internal.Reflections;
import minium.web.DocumentWebDriver;
import minium.web.MultipleDocumentDriversFoundException;
import minium.web.NoDocumentDriverFoundException;
import minium.web.WebElements;
import minium.web.internal.DefaultExpressionWebElements;
import minium.web.internal.ExpressionWebElements;
import minium.web.internal.HasJavascriptInvoker;
import minium.web.internal.InternalWebElements;
import minium.web.internal.drivers.JavascriptInvoker;
import minium.web.internal.expression.Coercer;
import minium.web.internal.expression.Expression;
import minium.web.internal.expression.FunctionInvocationExpression;
import minium.web.internal.expression.VariableGenerator;

public class ExpressionInvocationHandler<T extends WebElements>
extends AbstractInvocationHandler {
    private static final Method SIZE_METHOD = Reflections.getDeclaredMethod(BasicElements.class, (String)"size", (Class[])new Class[0]);
    private final TypeToken<T> typeVariableToken = new TypeToken<T>(((Object)((Object)this)).getClass()){};
    private final ElementsFactory<?> factory;
    private final Coercer coercer;

    public ExpressionInvocationHandler(ElementsFactory<?> factory, Coercer coercer) {
        this.factory = factory;
        this.coercer = coercer;
    }

    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        Preconditions.checkArgument((boolean)(proxy instanceof WebElements));
        WebElements parent = (WebElements)((WebElements)proxy).as(this.typeVariableToken);
        ExpressionWebElements webElements = (ExpressionWebElements)((InternalElementsFactory)this.factory.as(InternalElementsFactory.class)).createMixin((Elements)parent, new DefaultExpressionWebElements(method.getName(), args)).as(ExpressionWebElements.class);
        Class<?> returnClazz = method.getReturnType();
        if (returnClazz != Object.class && Elements.class.isAssignableFrom(returnClazz)) {
            return webElements.as(this.typeVariableToken);
        }
        JavascriptInvoker javascriptInvoker = ((HasJavascriptInvoker)parent.as(HasJavascriptInvoker.class)).javascriptInvoker();
        if (returnClazz == Void.TYPE) {
            Iterable<DocumentWebDriver> documentDrivers = ((InternalWebElements)parent.as(InternalWebElements.class)).documentDrivers();
            DocumentDriverInvoker documentDriverInvoker = new DocumentDriverInvoker(javascriptInvoker, webElements.getExpression());
            for (DocumentWebDriver documentDriver : documentDrivers) {
                documentDriverInvoker.apply(documentDriver);
            }
            result = null;
        } else {
            LinkedHashSet documentDrivers = Sets.newLinkedHashSet(((InternalWebElements)parent.as(InternalWebElements.class)).documentDrivers());
            switch (documentDrivers.size()) {
                case 0: {
                    if (method.equals(SIZE_METHOD)) {
                        return 0;
                    }
                    throw new NoDocumentDriverFoundException(String.format("The expression %s has no frame or window to be evaluated to", parent));
                }
                case 1: {
                    result = this.getSingleDocumentDriverResult((DocumentWebDriver)Iterables.get((Iterable)documentDrivers, (int)0), javascriptInvoker, webElements);
                    break;
                }
                default: {
                    Expression parentExpression = ((ExpressionWebElements)parent.as(ExpressionWebElements.class)).getExpression();
                    FunctionInvocationExpression sizeExpression = new FunctionInvocationExpression(parentExpression, "size", new Expression[0]);
                    DocumentWebDriver webDriverWithResults = this.getCandidateDocumentDriver(javascriptInvoker, sizeExpression, documentDrivers);
                    if (webDriverWithResults != null) {
                        DocumentDriverInvoker documentDriverInvoker = new DocumentDriverInvoker(javascriptInvoker, webElements.getExpression());
                        result = documentDriverInvoker.apply(webDriverWithResults);
                        break;
                    }
                    result = Defaults.defaultValue(returnClazz);
                }
            }
        }
        return this.coercer.coerce(result, method.getGenericReturnType());
    }

    protected DocumentWebDriver getCandidateDocumentDriver(JavascriptInvoker javascriptInvoker, Expression sizeExpression, Iterable<DocumentWebDriver> documentDrivers) {
        DocumentWebDriver webDriverWithResults = null;
        boolean multipleCandidates = false;
        Iterator<DocumentWebDriver> iterator = documentDrivers.iterator();
        while (iterator.hasNext()) {
            DocumentDriverInvoker documentDriverInvoker = new DocumentDriverInvoker(javascriptInvoker, sizeExpression);
            DocumentWebDriver candidate = iterator.next();
            long size = (Long)documentDriverInvoker.apply(candidate);
            if (size <= 0L) continue;
            if (webDriverWithResults == null) {
                webDriverWithResults = candidate;
                continue;
            }
            multipleCandidates = true;
        }
        if (multipleCandidates) {
            throw new MultipleDocumentDriversFoundException("Several frames or windows match the same expression, so value cannot be computed");
        }
        return webDriverWithResults;
    }

    protected Object getSingleDocumentDriverResult(DocumentWebDriver documentDriver, JavascriptInvoker javascriptInvoker, ExpressionWebElements webElements) {
        DocumentDriverInvoker documentDriverInvoker = new DocumentDriverInvoker(javascriptInvoker, webElements.getExpression());
        return documentDriverInvoker.apply(documentDriver);
    }

    private static class DocumentDriverInvoker
    implements Function<DocumentWebDriver, Object> {
        private final JavascriptInvoker javascriptInvoker;
        private final Expression expression;
        private boolean initialized;
        private String expressionJavascript;
        private Object[] expressionArgs;

        public DocumentDriverInvoker(JavascriptInvoker javascriptInvoker, Expression expression) {
            this.javascriptInvoker = javascriptInvoker;
            this.expression = expression;
        }

        public Object apply(DocumentWebDriver documentDriver) {
            if (!this.initialized) {
                VariableGenerator.Impl varGenerator = new VariableGenerator.Impl();
                this.expressionJavascript = this.expression.getJavascript(varGenerator);
                this.expressionArgs = this.expression.getArgs();
                this.initialized = true;
            }
            return this.javascriptInvoker.invokeExpression(documentDriver, this.expressionJavascript, this.expressionArgs);
        }
    }
}

