/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.rest.dto;

import cucumber.api.DataTable;
import cucumber.runtime.table.TableConverter;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.Row;
import java.util.ArrayList;
import java.util.List;
import minium.cucumber.rest.dto.CommentDTO;

public class DataTableDTO {
    private List<DataTableRowDTO> rows = new ArrayList<DataTableRowDTO>();

    public DataTableDTO() {
    }

    public DataTableDTO(DataTable dataTable) {
        List gherkinRows = dataTable.getGherkinRows();
        for (DataTableRow gherkinRow : gherkinRows) {
            this.rows.add(new DataTableRowDTO(gherkinRow));
        }
    }

    public List<DataTableRowDTO> getRows() {
        return this.rows;
    }

    public void setRows(List<DataTableRowDTO> rows) {
        this.rows = rows;
    }

    public DataTable toDataTable(TableConverter tableConverter) {
        ArrayList<DataTableRow> gherkinRows = new ArrayList<DataTableRow>();
        for (DataTableRowDTO row : this.rows) {
            gherkinRows.add(row.toDataTableRow());
        }
        return new DataTable(gherkinRows, tableConverter);
    }

    public static class DataTableRowDTO {
        private List<String> cells;
        private List<CommentDTO> comments;
        private Integer line;
        private Row.DiffType diffType;

        public DataTableRowDTO() {
        }

        public DataTableRowDTO(DataTableRow row) {
            this.cells = row.getCells();
            this.comments = CommentDTO.fromGherkinComments(row.getComments());
            this.line = row.getLine();
            this.diffType = row.getDiffType();
        }

        public List<String> getCells() {
            return this.cells;
        }

        public void setCells(List<String> cells) {
            this.cells = cells;
        }

        public List<CommentDTO> getComments() {
            return this.comments;
        }

        public void setComments(List<CommentDTO> comments) {
            this.comments = comments;
        }

        public Integer getLine() {
            return this.line;
        }

        public void setLine(Integer line) {
            this.line = line;
        }

        public Row.DiffType getDiffType() {
            return this.diffType;
        }

        public void setDiffType(Row.DiffType diffType) {
            this.diffType = diffType;
        }

        public DataTableRow toDataTableRow() {
            return new DataTableRow(CommentDTO.toGherkinComments(this.comments), this.cells, this.line, this.diffType);
        }
    }
}

