/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.data.reader;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import minium.cucumber.data.reader.DataDTO;
import minium.cucumber.data.reader.DataReader;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelDataReader
implements DataReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelDataReader.class);

    @Override
    public DataDTO readExamples(InputStream inputStream) {
        DataDTO dataDTO = new DataDTO();
        try (XSSFWorkbook workbook = new XSSFWorkbook(inputStream);){
            XSSFSheet sheet = workbook.getSheetAt(0);
            Iterator rowIterator = sheet.iterator();
            int i = 0;
            while (rowIterator.hasNext()) {
                Cell cell;
                Row row = (Row)rowIterator.next();
                Iterator cellIterator = row.cellIterator();
                if (i == 0) {
                    ArrayList header = Lists.newArrayList();
                    while (cellIterator.hasNext()) {
                        cell = (Cell)cellIterator.next();
                        header.add(cell.getStringCellValue());
                    }
                    dataDTO.setHeaders(header);
                } else {
                    ArrayList lineValues = Lists.newArrayList();
                    while (cellIterator.hasNext()) {
                        cell = (Cell)cellIterator.next();
                        lineValues.add(cell.getStringCellValue());
                    }
                    dataDTO.addLineValues(i, lineValues);
                }
                ++i;
            }
            inputStream.close();
        }
        catch (Exception e) {
            LOGGER.error("Error Reading Excel -  {}", (Object)e.getMessage());
        }
        return dataDTO;
    }

    @Override
    public DataDTO readTable(InputStream inputStream) {
        return null;
    }
}

