/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.expression;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import minium.web.internal.expression.CannotCoerceException;
import minium.web.internal.expression.Coercer;

public class JsonCoercer
implements Coercer {
    private final ObjectMapper mapper;

    public JsonCoercer() {
        this(null);
    }

    public JsonCoercer(ObjectMapper objectMapper) {
        this.mapper = objectMapper == null ? new ObjectMapper() : objectMapper;
    }

    @Override
    public boolean handles(Object obj, Type clazz) {
        return obj instanceof String;
    }

    @Override
    public Object coerce(Object obj, Type type) {
        try {
            JavaType javaType = TypeFactory.defaultInstance().constructType(type);
            return this.mapper.readValue(obj.toString(), javaType);
        }
        catch (JsonParseException e) {
            throw new CannotCoerceException(e);
        }
        catch (JsonMappingException e) {
            throw new CannotCoerceException(e);
        }
        catch (IOException e) {
            throw new CannotCoerceException(e);
        }
    }
}

