/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import minium.web.DocumentRoots;
import minium.web.DocumentWebDriver;
import minium.web.WebElements;
import minium.web.internal.ExpressionWebElements;
import minium.web.internal.InternalWebElements;
import minium.web.internal.WebElementFunctions;
import minium.web.internal.drivers.DocumentWebElement;
import minium.web.internal.expression.Expression;
import minium.web.internal.expression.NativeWebElementsExpression;
import org.openqa.selenium.WebElement;
import platypus.internal.Casts;

public class NativeWebElements<T extends WebElements>
extends InternalWebElements.Impl<T>
implements ExpressionWebElements {
    private final List<DocumentWebElement> nativeWebElements;

    public NativeWebElements(Collection<DocumentWebElement> nativeWebElements) {
        Preconditions.checkArgument((boolean)FluentIterable.from(nativeWebElements).allMatch(Predicates.instanceOf(DocumentWebElement.class)));
        this.nativeWebElements = Lists.newArrayList(nativeWebElements);
    }

    @Override
    public Iterable<DocumentWebDriver> candidateDocumentDrivers() {
        ImmutableSet documentDrivers = FluentIterable.from(this.nativeWebElements).transform(WebElementFunctions.unwrapDocumentDriver()).toSet();
        Preconditions.checkState((documentDrivers.size() <= 1 ? 1 : 0) != 0);
        return documentDrivers;
    }

    @Override
    public Iterable<DocumentWebDriver> documentDrivers() {
        return this.candidateDocumentDrivers();
    }

    @Override
    public DocumentRoots documentRoots() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public WebElements candidateDocumentRoots() {
        return this.documentRoots();
    }

    @Override
    public boolean isDocumentRoots() {
        return false;
    }

    @Override
    public Iterable<WebElement> computeNativeElements(DocumentWebDriver wd) {
        return (Iterable)Casts.unsafeCast(this.nativeWebElements);
    }

    @Override
    public Expression getExpression() {
        return new NativeWebElementsExpression(this.nativeWebElements);
    }

    public T freeze() {
        return (T)((WebElements)this.myself());
    }

    public String toString() {
        return String.format("$(<%d native elements>)", this.nativeWebElements.size());
    }
}

