/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import minium.BasicElements;
import minium.Elements;
import minium.web.DocumentWebDriver;
import minium.web.WebElements;
import minium.web.internal.ExpressionWebElements;
import minium.web.internal.FilteredDocumentRoots;
import minium.web.internal.HasExpressionizer;
import minium.web.internal.InternalWebElements;
import minium.web.internal.WebElementFunctions;
import minium.web.internal.drivers.DocumentWebElement;
import minium.web.internal.expression.Expression;
import minium.web.internal.expression.Expressionizer;
import minium.web.internal.expression.FunctionInvocationExpression;
import minium.web.internal.expression.NativeWebElementsExpression;
import minium.web.internal.expression.VariableGenerator;
import org.openqa.selenium.WebElement;

public class DefaultExpressionWebElements<T extends WebElements>
extends InternalWebElements.Impl<T>
implements ExpressionWebElements {
    private final String function;
    private final Object[] args;

    public DefaultExpressionWebElements(String function, Object ... args) {
        this.function = function;
        this.args = args == null ? new Object[]{} : args;
    }

    @Override
    public Expression getExpression() {
        Expression parentExpression = ((ExpressionWebElements)this.parent().as(ExpressionWebElements.class)).getExpression();
        Expressionizer expressionizer = ((HasExpressionizer)this.as(HasExpressionizer.class)).getExpressionizer();
        ImmutableList argExpressions = FluentIterable.from(Arrays.asList(this.args)).transform((Function)expressionizer).toList();
        return new FunctionInvocationExpression(parentExpression, this.function, (List<Expression>)argExpressions);
    }

    @Override
    public Iterable<DocumentWebDriver> candidateDocumentDrivers() {
        return ((InternalWebElements)this.parent().as(InternalWebElements.class)).candidateDocumentDrivers();
    }

    @Override
    public WebElements documentRoots() {
        return (WebElements)this.internalFactory().createMixin((Elements)this.myself(), new FilteredDocumentRoots());
    }

    @Override
    public WebElements candidateDocumentRoots() {
        return ((InternalWebElements)this.parent().as(InternalWebElements.class)).candidateDocumentRoots();
    }

    @Override
    public boolean isDocumentRoots() {
        return false;
    }

    @Override
    public Iterable<DocumentWebDriver> documentDrivers() {
        return FluentIterable.from(this.wrappedNativeElements()).transform(WebElementFunctions.unwrapDocumentDriver());
    }

    public T freeze() {
        return (T)((WebElements)this.internalFactory().createMixin((Elements)this.myself(), new ExpressionFrozenWebElements()));
    }

    public String toString() {
        String rootString = this.candidateDocumentRoots().toString();
        String expression = this.getExpression().getJavascript(new VariableGenerator.Impl());
        return Strings.isNullOrEmpty((String)rootString) ? expression : String.format("%s -> %s", rootString, expression);
    }

    static class ExpressionFrozenWebElements<T extends WebElements>
    extends InternalWebElements.Impl<T>
    implements ExpressionWebElements,
    BasicElements<T> {
        private List<DocumentWebElement> nativeWebElements;

        ExpressionFrozenWebElements() {
        }

        @Override
        public Iterable<DocumentWebDriver> candidateDocumentDrivers() {
            if (this.nativeWebElements == null) {
                return ((InternalWebElements)this.parent().as(InternalWebElements.class)).candidateDocumentDrivers();
            }
            return FluentIterable.from(this.wrappedNativeElements()).transform(WebElementFunctions.unwrapDocumentDriver());
        }

        @Override
        public Iterable<DocumentWebDriver> documentDrivers() {
            if (this.nativeWebElements == null) {
                return ((InternalWebElements)this.parent().as(InternalWebElements.class)).documentDrivers();
            }
            return FluentIterable.from(this.wrappedNativeElements()).transform(WebElementFunctions.unwrapDocumentDriver());
        }

        @Override
        public WebElements documentRoots() {
            return ((InternalWebElements)this.parent().as(InternalWebElements.class)).documentRoots();
        }

        @Override
        public WebElements candidateDocumentRoots() {
            return ((InternalWebElements)this.parent().as(InternalWebElements.class)).candidateDocumentRoots();
        }

        @Override
        public boolean isDocumentRoots() {
            return false;
        }

        @Override
        public Iterable<DocumentWebElement> wrappedNativeElements() {
            if (this.nativeWebElements == null) {
                ImmutableList elems = ImmutableList.copyOf(((InternalWebElements)this.parent().as(InternalWebElements.class)).wrappedNativeElements());
                if (elems.isEmpty()) {
                    return Collections.emptyList();
                }
                this.nativeWebElements = elems;
            }
            return this.nativeWebElements;
        }

        @Override
        public Expression getExpression() {
            ImmutableList nativeElems = ImmutableList.copyOf(this.wrappedNativeElements());
            return new NativeWebElementsExpression((List<? extends WebElement>)nativeElems);
        }

        public T freeze() {
            return (T)((WebElements)this.myself());
        }

        public String toString() {
            return this.parent().toString() + ".freeze()";
        }

        public T eq(int index) {
            return this.toWebElements((DocumentWebElement)Iterables.get(this.wrappedNativeElements(), (int)index, null));
        }

        public T first() {
            return this.toWebElements((DocumentWebElement)Iterables.getFirst(this.wrappedNativeElements(), null));
        }

        public T last() {
            return this.toWebElements((DocumentWebElement)Iterables.getLast(this.wrappedNativeElements(), null));
        }

        public int size() {
            return Iterables.size(this.wrappedNativeElements());
        }

        private T toWebElements(DocumentWebElement documentWebElement) {
            return documentWebElement == null ? this.factory().createNative(new DocumentWebElement[0]) : this.factory().createNative(documentWebElement);
        }
    }
}

