/*
 * Decompiled with CFR 0.152.
 */
package minium.web.config;

import java.io.IOException;
import java.util.List;
import minium.internal.Module;
import minium.web.CoreWebElements;
import minium.web.actions.Browser;
import minium.web.actions.WebDriverBrowser;
import minium.web.config.WebDriverFactory;
import minium.web.config.WebDriverProperties;
import minium.web.config.services.DriverServicesProperties;
import minium.web.internal.WebModule;
import minium.web.internal.WebModules;
import org.openqa.selenium.WebDriver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;

@Configuration
@EnableConfigurationProperties
public class WebElementsConfiguration {
    @Bean
    @ConfigurationProperties(prefix="minium.webdriver")
    public WebDriverProperties webDriverProperties() {
        return new WebDriverProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="minium.driverservices")
    public DriverServicesProperties driverServicesProperties() {
        return new DriverServicesProperties();
    }

    @Autowired
    @Bean
    public WebDriverFactory webDriverFactory(DriverServicesProperties driverServicesProperties) {
        return new WebDriverFactory(driverServicesProperties);
    }

    @Autowired
    @Bean(destroyMethod="quit")
    @Lazy
    public WebDriver wd(WebDriverFactory webDriverFactory, WebDriverProperties webDriverProperties) throws IOException {
        return webDriverFactory.create(webDriverProperties);
    }

    @Autowired
    @Bean
    @Lazy
    @Order(value=-2147483648)
    public WebModule defaultWebModule(WebDriver wd) {
        return WebModules.combine((WebModule[])new WebModule[]{WebModules.defaultModule((WebDriver)wd), WebModules.debugModule()});
    }

    @Autowired
    @Bean(destroyMethod="quit")
    @Lazy
    public Browser<CoreWebElements.DefaultWebElements> browser(WebDriver webDriver, List<WebModule> modules) {
        WebModule combinedWebModule = WebModules.combine(modules);
        return new WebDriverBrowser(webDriver, CoreWebElements.DefaultWebElements.class, (Module)combinedWebModule);
    }
}

